<?php
/**
 * @desc this program will add or edit a logaholic user account
 * for more information please read:
 * http://www.logaholic.com/manual/LogaholicManual/APIDocumentationForServiceProviderEditions
 */

class LogaholicDBDatamanger
{
    var $profilename;
    var $globalsetting;
    var $maxdaterange;
    var $maxstorage;
    var $datadir;

    function __construct()
    {
        global $config, $running_from_command_line, $db, $databasedriver;

        $running_from_command_line = true;
        include_once $config['path'] . "/common.inc.php";

        $this->globalsetting = false;
        $this->profilename = '';
        $this->maxdaterange = '';
        $this->maxstorage = '';
        $this->datadir = '';

        # first check the variables we need to execute this program
        $this->CheckVars();

        # now connect to the database
        // $this->dbConnect();
    }

    function CheckVars()
    {
        global $action;
        $help = "To edit a Global setting, set globalsetting to true and do not enter a profilename.<br>\n";
        $help .= "Required at least one of these variables:<br>\n";
        $help .= "globalsetting (editmanager)<br>\n";
        $help .= "profilename (editmanager)<br>\n";
        $help .= "Required at least one of these variables:<br>\n";
        $help .= "maxdaterange [ 0 = no limit, 1,2,3,4,5,6,12 are the amount of months ] (editmanager)<br>\n";
        $help .= "maxstorage (editmanager)<br>\n";
        $help .= "datadir (editmanager)<br>\n";
        $help .= "Actions that can be requested:<br>\n";
        $help .= "editdatamanager<br>\n";
        $help .= "\n\nPlease note: Setting a datadir will also attempt to create that dir and chmod it to 777";

        # Check if a profilename or globalsetting is set or set to false.
        if (empty($_GET["profilename"]) && (empty($_GET["globalsetting"]) || $_GET["globalsetting"] == false)) {
            output($help, true);
        }
        # if profilename and globalsetting is set..
        if (!empty($_GET["profilename"]) && !empty($_GET["globalsetting"]) && $_GET["globalsetting"] == true) {
            output($help, true);
        }

        # Check if there is a setting given to actually change
        if (empty($_GET["maxdaterange"]) && empty($_GET["maxstorage"]) && empty($_GET["datadir"])) {
            output($help, true);
        }

        # Check if there is a setting given to actually change
        if (!empty($_GET["maxdaterange"]) && !is_numeric($_GET["maxdaterange"])) {
            output($help, true);
        }

        if (!empty($_GET["profilename"])) {
            $this->profilename = $_GET["profilename"];
        }

        if (!empty($_GET["globalsetting"])) {
            $this->globalsetting = $_GET["globalsetting"];
        }

        if (!empty($_GET["maxdaterange"])) {
            $this->maxdaterange = $_GET["maxdaterange"];
        }

        if (!empty($_GET["maxstorage"])) {
            $this->maxstorage = $_GET["maxstorage"];
        }

        if (!empty($_GET["datadir"])) {
            $this->datadir = $_GET["datadir"];
        }
    }

    function dbConnect()
    {
        global $db, $config;
        require_once($config['path'] . "/common.inc.php");

        // require_once($config['path']."/files/global.php");
        // require_once($config['path']."/components/adodb/adodb-errorhandler.inc.php");  
        // require_once($config['path']."/components/adodb/adodb.inc.php");

        // if (function_exists("mysqli_connect")) {
        //     $db = ADONewConnection("mysqli");
        // } else {
        //     $db = ADONewConnection("mysql");
        // }        
        // @$db->Connect($mysqlserver,$mysqluname,$mysqlpw,$DatabaseName) or Output("An error occurred: ".$db->ErrorMsg(),true);

    }

    function EditDatamanager()
    {
        global $db;
        if (!empty($this->profilename)) {
            # Datamanager Settings
            if (!empty($this->maxdaterange)) {
                setProfileData($this->profilename, $this->profilename . ".datamanagersettings", $this->maxdaterange);
                output("Success: Edited Datamanager Range settings.<br>\n");
            }
            if (!empty($this->datadir)) {
                $this->CreateDatadir($this->datadir);
                setProfileData($this->profilename, $this->profilename . ".datamanagerDirectory", $this->datadir);
                output("Success: Edited Datamanager Dir settings.<br>\n");
            }
            if (!empty($this->maxstorage)) {
                setProfileData($this->profilename, $this->profilename . ".datamanagerStorageSize", $this->maxstorage);
                output("Success: Edited Datamanager Storage settings.<br>\n");
            }
        }
        if ($this->globalsetting) {
            # Datamanager Settings
            if (!empty($this->maxdaterange)) {
                setGlobalSetting("datamanagersettings", $this->maxdaterange);
                output("Success: Edited Global Datamanager Range settings.<br>\n");
            }
            if (!empty($this->datadir)) {
                $this->CreateDatadir($this->datadir);
                setGlobalSetting("datamanagerDirectory", $this->datadir);
                output("Success: Edited Global Datamanager Dir settings.<br>\n");
            }
            if (!empty($this->maxstorage)) {
                setGlobalSetting("datamanagerStorageSize", $this->maxstorage);
                output("Success: Edited Global Datamanager Storage settings.<br>\n");
            }
        }
        output("Finished editing Datamanager.<br>\n");
    }

    function CreateDatadir($datadir)
    {
        if (!file_exists($datadir)) {
            if (mkdir($datadir) == true) {
                if (chmod($datadir, 0644) == false) {
                    output("Success: create datadir at $datadir but could not change permissions!");
                } else {
                    output("Success: create datadir at $datadir");
                }
            }
        }
    }
}