<?php

require_once 'core_factory.php';
Logaholic_sessionStart();

$lang = Logaholic_setLang();

include_once "languages/$lang.php";

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Logaholic</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <link rel="icon" href="favicon.ico?v=2" type="image/x-icon">
    <link rel="shortcut icon" href="favicon.ico?v=2" type="image/x-icon">

    <link rel="stylesheet" type="text/css" media="screen, print, projection" href="templates/logaholic_6/css/css.php"/>
    <!-- Logaholic 6 CSS -->
    <link href="components/tutorial/tutorial.css" rel="stylesheet" type="text/css"/>

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <!-- JS resources -->
    <script src="templates/logaholic_6/js/js.php" type="text/javascript"></script>
    <script src="components/tutorial/tutorials.js.php" type="text/javascript"></script>

    <!-- InputMask -->
    <script src="templates/logaholic_6/js/plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
    <script src="templates/logaholic_6/js/plugins/input-mask/jquery.inputmask.date.extensions.js"
            type="text/javascript"></script>


    <style>
        .loadui {
            position: absolute;
            top: 35%;
            left: 45%;
        }

        .uiloader {
            position: absolute;
            left: 0;
            top: 0;
            right: 0;
            bottom: 0;
            margin: auto;
            background-color: #E9E9E9;
            opacity: 0.83;
            z-index: 1100;
            text-align: center;
        }
    </style>
</head>
<body class="skin-logaholic">
<div class="uiloader">
    <div class="loadui"><h2><i class="fa fa-spinner fa-pulse"></i><br>Loading</h2></div>
</div>
<header class="header">
    <a href="index.php" class="logaholiclogo hidden-xs" title="Logaholic <?php
    echo _CONTROL_PANEL; ?>"><i></i><span>Logaholic</span></a>


    <nav class="navbar navbar-static-top" role="navigation">
        <!-- Sidebar toggle button-->
        <!-- <a href="#" class="navbar-btn sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
        </a> -->
        <a href="index.php" class="logaholiclogo visible-xs" title="Logaholic Control Panel"><i></i></a>
        <ul class="nav navbar-nav">
            <li class="">
                <a href="#" class="sidebar-toggle" data-toggle="offcanvas">
                    <span class="sr-only">Toggle navigation</span>
                    <i class="fa fa-bars"></i>
                </a>
            </li>
            <li class="dropdown tasks-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                    <i class="fa fa-folder-open"></i>
                </a>
                <ul class="dropdown-menu profilemenu">
                    <li class="header"><?php
                        echo _YOU_HAVE; ?> <span class="num_profiles"></span> <?php
                        echo strtolower(_PROFILES); ?><br>
                        <input type="text" name="psearch" id="psearch" placeholder="<?php
                        echo _SEARCH . " " . _PROFILES; ?>" class="form-control">
                    </li>
                    <li>
                        <ul class="menu">
                            <li>
                                <a class="menurow" href="#">
                                    <h3 class="pull-left" style="line-height:30px; margin-bottom:0;">Profilename
                                    </h3>
                                    <div class="btn-group pull-right">
                                        <button class="btn btn-sm btn-success view"><?php
                                            echo _VIEW; ?></button>
                                        <button class="btn btn-sm btn-success edit"><?php
                                            echo _EDIT; ?></button>
                                        <button class="btn btn-sm btn-success update"><?php
                                            echo _UPDATE; ?></button>
                                    </div>
                                    <div style="clear:both;"></div>
                                </a>

                            </li>
                        </ul>
                    </li>
                    <li class="footer">
                        <a href="index.php"><?php
                            echo _MANAGE_PROFILES; ?></a>
                    </li>
                </ul>


            </li>

        </ul>
        <div class="navbar-left">

        </div>
        <div class="navbar-right">
            <ul class="nav navbar-nav">

                <li class="dropdown messages-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="fa fa-envelope"></i>
                        <span class="label label-danger" style="display:none;"></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li class="header mesnum">You have 0 messages</li>
                        <li>
                            <ul class="menu">
                                <li style="display:none;">
                                    <a href="#">
                                        <div class="pull-left">

                                        </div>
                                        <strong style="color:#444444;">
                                            Logaholic Support Team
                                        </strong>

                                    </a>
                                </li>

                            </ul>
                        </li>
                        <li class="footer"><a href="https://www.logaholic.com/blog/">See All News</a></li>
                    </ul>
                </li>

                <!-- help menu -->
                <li class="dropdown help-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="fa fa-info"></i>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="manuallink" target="_blank" data-lang="<?php
                            echo $lang; ?>" href="https://www.logaholic.com/manual/">Logaholic Manual</a></li>
                        <li><a class="qalink" href="#">Ask a Question</a></li>
                        <li class="divider"></li>
                        <li><a href="#" class="tutorial-start" data-tutorial="header-controls">Tutorial: <?php
                                echo _TUT6_BASIC; ?></a></li>
                        <li><a href="#" class="tutorial-start cp-profiletutorial"
                               data-tutorial="cp-profiles">Tutorial: <?php
                                echo _CREATE_NEW_PROFILE; ?></a></li>
                        <!-- <li><a href="#" title="Only viewable in Edit Profile" class="tutorial-start disabled" data-tutorial="create-profile">Tutorial: Profile</a></li> -->
                        <li><a href="#" class="tutorial-start dashboardtutorial" data-tutorial="dashboard-controls">Tutorial: <?php
                                echo _DASHBOARD; ?></a></li>
                        <li><a href="#" class="tutorial-start reporttutorial"
                               data-tutorial="report-handling">Tutorial: <?php
                                echo _REPORTS; ?></a></li>
                    </ul>
                </li>
                <!-- UserAccount -->
            </ul>
        </div>
    </nav>
</header>
<div class="wrapper row-offcanvas row-offcanvas-left">

    <aside class="left-side sidebar-offcanvas">

        <section class="sidebar">
            <!-- search form -->
            <div class="input-group sidebar-form">
                <input type="text" name="searchmenu" class="form-control search_menu" placeholder="Search..."/>
                <span class="input-group-btn">
                            <button type='submit' name='search' id='search-btn' class="btn btn-flat"><i
                                        class="fa fa-search"></i></button>
                        </span>
            </div>
            <!-- /.search form -->

            <ul class="sidebar-menu" name="reports-menu" id="main-menu">
                <li class="treeview">
                    <a href="#">
                        <i class="fa"></i>
                        <span class="categorie-name"></span>
                        <i class="fa fa-angle-left pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li><a href=""><i class="fa fa-angle-double-right"></i><span class="report-name"></span></a>
                        </li>
                    </ul>
                </li>
            </ul>

        </section>

        <!-- /.sidebar -->
    </aside>

    <!-- Right side column. Contains the navbar and content of the page -->
    <aside class="right-side">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <span class="confname"></span>

                <small class="pagename manage-dashs">Page</small>
                <span class="toolbar">
                            <!-- .content-header .toolbar -->
                        </span>
            </h1>

        </section>

        <div class="system-response">
            <div class="callout-danger-system callout callout-danger" style="display:none;">
                <h4></h4>
            </div>
        </div>

        <!-- Main content -->
        <section class="content">

            <div class="general-response">

                <div class="callout-danger-template callout callout-danger" style="display:none;">
                    <h4></h4>
                </div>

                <div class="callout-success-template callout callout-success" style="display:none;">
                    <h4><span></span></h4>
                </div>
            </div>

            <!-- .content -->

        </section><!-- /.content -->
    </aside><!-- /.right-side -->
</div><!-- ./wrapper -->


<!-- Modal -->
<div id="errorModal" class="modal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Error Report</h4>
            </div>
            <div class="modal-body">
                <p>Some error.</p>
            </div>
            <div class="modal-footer">
                <button class='btn btn-success send_error_report' data-dismiss="modal">Send Error Report</button>
            </div>
        </div>

    </div>
</div>
<div id="versionCheckModal" class="modal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Version Check</h4>
            </div>
            <div class="modal-body">
                <p>Please wait while we update the system and/or profile.</p>
            </div>
            <div class="modal-footer">
                <button class='btn btn-success versioncheck-reload' href='#'
                        data-loading-text="Please wait while we update the system and/or profile.">Reload Page
                </button>
            </div>
        </div>

    </div>
</div>

<div id="tutorialbox"></div>

<div id="tutorialPopUp" class="modal" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 align="center" class="modal-title"><?php
                    echo _WELCOME_LOGAHOLIC_SOFTWARE; ?></h4>
            </div>
            <div class="modal-body">
                <div align="">
                    <p align="center"><b><?php
                            echo _TUT6_AVAILABLE; ?>:</b></p>
                    <ul>
                        <li>
                            <a href="#" class="tutorial-start" data-tutorial="header-controls"><?php
                                echo _TUT6_BASIC; ?></a>
                            <p><?php
                                echo _TUT6_BASIC_EXPLAIN; ?></p>
                        </li>

                        <li>
                            <a href="#" title="" id="cp-profiletutorial" class="tutorial-start cp-profiletutorial"
                               data-tutorial="cp-profiles"><?php
                                echo _CREATE_NEW_PROFILE; ?></a>
                            <p><?php
                                echo _TUT6_CP_EXPLAIN; ?></p>
                        </li>

                        <li>
                            <a href="#" title="" id="dashboardtutorial" class="tutorial-start dashboardtutorial"
                               data-tutorial="dashboard-controls"><?php
                                echo _DASHBOARD; ?></a>
                            <p><?php
                                echo _TUT6_DASH_EXPLAIN; ?></p>
                        </li>

                        <li>
                            <a href="#" title="" id="reporttutorial" class="tutorial-start reporttutorial"
                               data-tutorial="report-handling"><?php
                                echo _REPORTS; ?></a>
                            <p><?php
                                echo _TUT6_REPORT_EXPLAIN; ?></p>
                        </li>

                    </ul>
                </div>
            </div>
            <div class="modal-footer">

                <div class="pull-left" style="margin-left:20px">
                    <label class="checkbox">
                        <input type="checkbox" id="dont" name="dont" value="1"> <?php
                        echo _NEVER_SHOW_AGAIN; ?>
                    </label>
                </div>
                <button id="CloseButton" class='btn btn-default' data-dismiss="modal"><?php
                    echo ucwords(_CLOSE); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="widgetModal" class="modal" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">&nbsp;</h4>
            </div>
            <div class="modal-body"></div>
            <div style="clear:both;"></div>
        </div>
    </div>
</div>

<!-- licenseModal -->

<!-- add new calendar event modal -->
<!-- Load js sources -->
<div id="javascripts">
    <!-- Default Logaholic Scripts -->
    <?php
    // if (LOGAHOLIC_VERSION_STATUS == "dev") {
    //     echo '<script src="templates/logaholic_6/js/AdminLTE/app.js" type="text/javascript"></script>';
    //     echo '<script src="app/controller/index.js" type="text/javascript"></script>';
    //     echo '<script src="templates/logaholic_6/js/plugins/daterangepicker/daterangepicker.js" type="text/javascript"></script>';
    //     echo '<script src="templates/logaholic_6/js/plugins/datatables/jquery.dataTables10.js" type="text/javascript"></script>';
    //     echo '<script src="templates/logaholic_6/js/plugins/datatables/dataTables.bootstrap10.js" type="text/javascript"></script>';
    //     echo '<script src="app/functions.js" type="text/javascript"></script>';
    //     echo '<script src="components/jwt/jwt-decode.js" type="text/javascript"></script>';
    //     echo '<script src="components/d3.v3/nv.d3.js" type="text/javascript"></script>';
    //     echo '<script src="components/leaflet-0.6.4/leaflet-src.js" type="text/javascript"></script>';


    // } else {
    echo '<script src="app/controller/app-index.min.js" type="text/javascript"></script>';
    //}
    ?>


    <!-- Logaholic Scripts -->
    <!-- Logaholic Controllers -->
</div>
</body>
</html>
