<?php

$reports["_TRANSALARM_SANDBOX"] = [
    "ClassName" => "TransalarmSandbox",
    "Category" => "_TRANSALARM",
    "icon" => "images/icons/32x32/goals.png",
    "Options" => "daterangeField",
    "Filename" => "trans_alarm_sandbox",
    "Distribution" => "Unlisted",
    "hidden" => true,
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 4.0,
    "EmailAlerts" => true,
    "Update" => false
];

class TransalarmSandbox extends Report
{

    function Settings()
    {
        $this->datafiles = false;

        $this->columnDefinitions[] = ["Label" => "_HITS"];
        $this->columnDefinitions[] = ["Label" => "_METRIC"];
        $this->columnDefinitions[] = ["Label" => "_EVENT"];
    }

    function DefineQuery()
    {
        return "SELECT count(*), metric, event_type from " . TBL_TRANSALARM_LOG . "_sandbox WHERE `profile` = '{$this->profile->profilename}' GROUP BY metric, event_type ORDER BY `timestamp`";
    }

    function DisplayReport()
    {
        global $reports, $logaTA;
        /* Turn on sandbox Mode */
        $logaTA->SandBoxMode(true);

        $data = [];

        $log = [];

        # test are set from the daterange
        $time = $this->from;
        while ($time < $this->to) {
            # Set the daterange for the parser
            $logaTA->from = mktime(
                0,
                0,
                0,
                date("m", $time),
                date("d", $time) - $logaTA->config['ResetDays'],
                date("Y", $time)
            );
            $logaTA->to = mktime(23, 59, 59, date("m", $time), date("d", $time) - 1, date("Y", $time));

            # Parse the data
            $logaTA->ParseAllData();

            # Add an hour to the time
            $time = mktime(0, 0, 0, date("m", $time), date("d", $time) + 1, date("Y", $time));
        }

        /* Turn off sandbox Mode */
        $logaTA->SandBoxMode(false);

        $data = $this->GetReportData();

        foreach ($data as $i => $v) {
            $data[$i][1] = "<a class='open_in_new_dialog quickopen' type='_TRANSALARM_LOG_DETAIL' name='" . _TRANSALARM_LOG_DETAIL . "' href='reports.php?conf={$this->profile->profilename}&labels=_TRANSALARM_LOG_DETAIL&metric={$v[1]}&sandbox=1'>{$v[1]}</a>";
        }

        $this->Table($data);
    }
}