<?php

require_once '../../AccessControl.php';
include "index.php";

$menu_items = [];
$menu_cat = [];

# define the menu categories
$menu_cat["_PROFILES"] = ["text" => _PROFILES, "icon" => "fa-folder-open"];

# define the menu items
$menu_items["_MANAGE_PROFILES"] = [
    "text" => _MANAGE_PROFILES,
    "action" => "cp.ProfileTable()",
    "cat" => "_PROFILES"
];

if ($session->canAddProfiles()) {
    $menu_items["_CREATE_NEW_PROFILE"] = [
        "text" => _CREATE_NEW_PROFILE,
        "action" => "cp.CreateNewProfiles()",
        "cat" => "_PROFILES"
    ];
}

# Admin only menu items 
if ($session->isAdmin()) {
    $menu_items["_IMPORT_PROFILES"] = [
        "text" => _IMPORT_PROFILES,
        "action" => "cp.ImportProfiles()",
        "cat" => "_PROFILES"
    ];
    $menu_cat["_USERS"] = ["text" => _USERS, "icon" => "fa-user"];
    $menu_cat["_LOCALIZATION"] = ["text" => _LOCALIZATION, "icon" => "fa-globe"];
    $menu_cat["_PRIVACY"] = ["text" => _PRIVACY, "icon" => "fa-eye"];
    $menu_cat["_DATA_STORAGE"] = ["text" => _DATA_STORAGE, "icon" => "fa-archive"];

    $menu_items["_ACTIVATE_PROFILES"] = [
        "text" => _ACTIVATE_PROFILES,
        "action" => "cp.ActivateAllProfiles()",
        "cat" => "_PROFILES"
    ];

    $menu_items["_EDIT_USER"] = ["text" => _EDIT_USER, "action" => "cp.CreateEditUser()", "cat" => "_USERS"];
    $menu_items["_USER_ADMINISTRATION"] = [
        "text" => _USER_ADMINISTRATION,
        "action" => "cp.UserAdministration()",
        "cat" => "_USERS"
    ];
    $menu_items["_CREATE_NEW_USER"] = [
        "text" => _CREATE_NEW_USER,
        "action" => "cp.CreateEditUser()",
        "cat" => "_USERS"
    ];
    $menu_items["_AUTHENTICATION_METHOD"] = [
        "text" => _AUTHENTICATION_METHOD,
        "action" => "cp.AuthenticationMethod()",
        "cat" => "_USERS"
    ];


    $menu_items["_LANGUAGES"] = [
        "text" => _LANGUAGES,
        "action" => "cp.ChangeDefaultLang()",
        "cat" => "_LOCALIZATION"
    ];
    $menu_items["_DATE_FORMAT"] = [
        "text" => _DATE_FORMAT,
        "action" => "cp.ChangeDefaultDateFormat()",
        "cat" => "_LOCALIZATION"
    ];

    $menu_items["_IP_MASKING"] = ["text" => _IP_MASKING, "action" => "cp.IPmasking()", "cat" => "_PRIVACY"];
    $menu_items["_EMAIL_ALERTS"] = ["text" => _EMAIL_ALERTS, "action" => "cp.EmailAlerts()", "cat" => "_PRIVACY"];
    $menu_items["_USAGE_TRACKING"] = [
        "text" => _USAGE_TRACKING,
        "action" => "cp.UsageTracking()",
        "cat" => "_PRIVACY"
    ];

    $menu_items["_DATABASE_INFO"] = [
        "text" => _DATABASE_INFO,
        "action" => "cp.DatabaseInfo()",
        "cat" => "_DATA_STORAGE"
    ];
    $menu_items["_DATAMANAGER_SETTINGS"] = [
        "text" => _DATAMANAGER_SETTINGS,
        "action" => "cp.DataManager()",
        "cat" => "_DATA_STORAGE"
    ];
    $menu_items["_CHANGE_UPLOAD_DIR"] = [
        "text" => _CHANGE_UPLOAD_DIR,
        "action" => "cp.ChangeUploadDirectory()",
        "cat" => "_DATA_STORAGE"
    ];
    $menu_items["_URL_SENSITIVE"] = [
        "text" => _URL_SENSITIVE,
        "action" => "cp.UrlCaseSensitivity()",
        "cat" => "_DATA_STORAGE"
    ];
} else {
    if ($session->canEditUserInfo()) {
        # only when not admin
        $menu_cat["_USER"] = ["text" => _USER, "icon" => "fa-user"];
        $menu_items["_EDIT_USER"] = ["text" => _EDIT_USER, "action" => "cp.CreateEditUser()", "cat" => "_USER"];
    }
}

if ($session->isAdmin()) {
    $menu_cat["_SYSTEM"] = ["text" => _SYSTEM, "icon" => "fa-gears"];
    $menu_cat["_SOFTWARE"] = ["text" => _SOFTWARE, "icon" => "fa-cloud"];

    if (defined(_LOGAHOLIC_EDITION) == 5) {
        $menu_items["_SETUP_REPORT_SUBSCRIPTIONS"] = [
            "text" => _SETUP_REPORT_SUBSCRIPTIONS,
            "action" => "cp.SetupSubscriptions()",
            "cat" => "_SYSTEM"
        ];
    }
    // $menu_items["_REPORT_STORE"] = array("text" => _REPORT_STORE, "action" => "cp.ChangeAffiliateID()", "cat" => "_SYSTEM");
    $menu_items["_CLUSTER_MANAGER"] = [
        "text" => _CLUSTER_MANAGER,
        "action" => "cp.ClusterManager()",
        "cat" => "_SYSTEM"
    ];

    $menu_items["_SIGNUP"] = ["text" => _ALLOW_SIGNUP, "action" => "cp.Signup()", "cat" => "_SYSTEM"];

    $menu_items["_INSTALLATION_SETUP"] = [
        "text" => _INSTALLATION_SETUP,
        "action" => "cp.Installation()",
        "cat" => "_SOFTWARE"
    ];
    $menu_items["_GET_LICENSE"] = ["text" => _GET_LICENSE, "action" => "cp.GetLicense()", "cat" => "_SOFTWARE"];
    $menu_items["_CHECK_FOR_UPDATES"] = [
        "text" => _CHECK_FOR_UPDATES,
        "action" => "cp.UpdateLogaholic()",
        "cat" => "_SOFTWARE"
    ];
    $menu_items["_UNINSTALL_LOGAHOLIC"] = [
        "text" => _UNINSTALL_LOGAHOLIC,
        "action" => "cp.UninstallLogaholic()",
        "cat" => "_SOFTWARE"
    ];
}


# merge menu items into cat array so js can easily loop thru it to make the menu
foreach ($menu_items as $key => $val) {
    $menu_cat[$val['cat']]['data'][$key] = $menu_items[$key];
}

//has license?
$hl = false;
if (_LOGAHOLIC_EDITION != 0) {
    $hl = true;
}
if ($ss) {
    $hl = true;
}
$str = json_encode([
                       'Status' => 'Success',
                       'languages' => $lang_labels,
                       'profiles' => $plist,
                       'pcount' => $pcount,
                       'available_langs' => $available_langs,
                       'lang' => $lang,
                       'getdatafromstore' => $getdatafromstore,
                       'session' => $session,
                       'usage_tracking' => $usage_tracking,
                       'hl' => $hl,
                       'ss' => $ss,
                       'menu_items' => $menu_items,
                       'menu_cat' => $menu_cat,
                       'version_check' => $must_load_version_check
                   ]);
ob_start();
echo $str;
print_gzipped_output();
