<?php

$reports["_TRANSALARM_DASHBOARD"] = [
    "ClassName" => "TransalarmDashboard",
    "Category" => "_TRANSALARM",
    "icon" => "images/icons/32x32/goals.png",
    "Options" => "",
    "Filename" => "trans_alarm_dashboard",
    "Distribution" => "Unlisted",
    "hidden" => true,
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 4.0,
    "EmailAlerts" => true,
    "Update" => false
];

class TransalarmDashboard extends Report
{
    function Settings()
    {
        global $logaTA;
        $this->columnDefinitions[] = ["Label" => '_PROFILE'];
        $this->columnDefinitions[] = ["Label" => '_METRIC'];
        $this->columnDefinitions[] = ["Label" => "_STATUS", "disableShowfieldsHandling" => true];
        $this->columnDefinitions[] = ["Label" => 'Confirmed Date'];
        $this->columnDefinitions[] = ["Label" => 'Previous Status Date'];
        $this->columnDefinitions[] = ["Label" => 'Net Err Days'];

        if (!empty($this->sandbox)) {
            $logaTA->persistantDataTable = TBL_TRANSALARM_DATA . "_sandbox";
        }
    }

    function DisplayCustomForm()
    {
        echo "<label style='line-height: 38px;'>";
        if (!empty($this->sandbox)) {
            echo "<input class='report_option_field' type='checkbox' style='float: left;  margin: 13px 0 0; width: 20px;' name='sandbox' id='sandbox' checked='checked' />";
        } else {
            echo "<input class='report_option_field' type='checkbox' style='float: left;  margin: 13px 0 0; width: 20px;' name='sandbox' id='sandbox' />";
        }
        echo "Sandbox";
        echo "</label>";
    }

    function GetReportData()
    {
        global $db;
        $data = [];

        $r = $db->Execute($this->DefineQuery());

        $i = 0;
        while ($row = $r->fetchRow()) {
            $max = max($row[3], $row[4]);
            $min = min($row[3], $row[4]);

            if (empty($row[3]) && empty($row[4])) {
                $s = 'N/A';
            } else {
                if ($row[3] > $row[4]) {
                    $s = "<span style='color:green;'>Ok</span>";
                } else {
                    $s = "<span style='color:red;'>" . _ERROR . "</span>";
                }
            }

            $sandbox = "";
            if (!empty($this->sandbox)) {
                $sandbox = "&sandbox=1";
            }

            $data[$i][0] = $row[0];
            $data[$i][1] = "<a class='open_in_new_dialog quickopen' type='_TRANSALARM_LOG_DETAIL' name='" . _TRANSALARM_LOG_DETAIL . "' href='reports.php?conf={$this->profile->profilename}&labels=_TRANSALARM_LOG_DETAIL&metric={$row[1]}{$sandbox}'>{$row[1]}</a>";
            $data[$i][2] = $s;
            $data[$i][3] = date("m/d/Y", $max);
            $data[$i][4] = (empty($min)) ? 'N/A' : date("m/d/Y", $min);
            $data[$i][5] = (empty($min)) ? '-' : ceil(($max - $min) / 86400);

            $i++;
        }

        return $data;
    }

    function DefineQuery()
    {
        global $logaTA;
        $query = "SELECT * FROM " . $logaTA->persistantDataTable . " WHERE profile = '{$this->profile->profilename}'";
        return $query;
    }
}