<?php

/**
 * @desc This report displays the used os versions
 */

$reports["_OS_VERSIONS_BY_COUNTRY"] = [
    "ClassName" => "OSVersionsByCountry",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/os_versions.png",
    "Options" => "daterangeField,displaymode,limit,trafficsource,profileselector,country_list,columnSelector",
    "Filename" => "os_versions_by_country",
    "Distribution" => "Premium",
    "Order" => 7,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false
];

class OSVersionsByCountry extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "sunburst";
        $this->DisplayModes = "sunburst,drilldown,table";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }

        $this->columnDefinitions[] = ["Label" => "_COUNTRY", "search" => true];
        $this->columnDefinitions[] = ["Label" => "_OPERATING_SYSTEM"];
        $this->columnDefinitions[] = ["Label" => "_VERSION"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "_SUM_DAILY_UNIQUE_VISITORS"];
        $this->columnDefinitions[] = ["Label" => "sortkey", "display" => false];
        $this->key_col = 5;
        $this->sort = false; // we do custom sorting

        $this->trendlink = "<i class='fa fa-line-chart open_in_new_dialog' style='float:right' type='_OS_TRENDS' rel='OSTrends' href='reports.php?conf={$this->profile->profilename}&amp;labels=_OS_TRENDS&amp;country_name=%country'></i></a>";
        if ($this->labels == "_AG_OS_VERSIONS_BY_COUNTRY") {
            $this->trendlink = "<i class='fa fa-line-chart open_in_new_dialog' style='float:right' type='_AG_OS_TRENDS' rel='AggregatorOSTrends' href='reports.php?conf={$this->profile->profilename}&amp;labels=_AG_OS_TRENDS&amp;country_name=%country&amp;from={$this->from}&amp;to={$this->to}&amp;profilelist={@$this->profilelist}'></i></a>";
        }
        if (!isset($this->limit)) {
            $this->limit = 10;
        }
        $this->report_limit = $this->limit;
    }

    function DefineQuery()
    {
        global $db;
        $query = "SELECT country, ua.os, IF(ua.os_version='','Unknown',ua.os_version) AS os_name, COUNT(DISTINCT a.sessionid) AS visits, COUNT(DISTINCT a.visitorid) AS visitors, concat(country,ua.os_version) as g FROM {$this->profile->tablename} AS a, {$this->profile->tablename_useragents} as ua WHERE a.useragentid = ua.id AND  a.timestamp BETWEEN " . $db->quote(
                $this->from
            ) . " AND " . $db->quote($this->to) . " GROUP BY g, a.country, ua.os, os_version ";
        $query .= "ORDER BY country ASC, visits DESC";
        //echoWarning($query);
        return $query;
    }

    function DisplayReport()
    {
        $data = $this->GetReportData();

        $this->ReportHeader();
        $this->displayHeader = false;

        if (empty($data)) {
            echoNotice(_NO_DATA_FOR_THIS_DATE_RANGE, "margin: 10px;");
            return false;
        }

        if ($this->displaymode == "drilldown") {
            $collapsekeys = [0, 1, 2];
            $sumkeys = [3, 4];
            $this->CollapseTable($data, $collapsekeys, $sumkeys);
            return;
        }
        if ($this->displaymode == "sunburst") {
            $this->collapsekeys = [0, 1, 2];
            $this->sumkeys = [3, 4];

            $this->Sunburst($data);
            return;
        }

        $this->limit = 10000;
        $this->paginationPanel = true;
        $this->Table($data);
    }

    function GetReportData()
    {
        $this->limit = 10000;
        $data = parent::GetReportData();
        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }
}


