<?php

const _MINI_VISITS_TRENDS = _VISITS_TRENDS;

$reports["_MINI_VISITS_TRENDS"] = [
    "ClassName" => "MiniVisitsTrends",
    "Category" => "_KEY_METRIC",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,profileselector",
    "Filename" => "metric_visits_trends",
    "Distribution" => "Standard",
    "Order" => 2,
    "ReportVersion" => 6.0,
    "MinimumVersion" => 6.0,
    "Update" => false
];

class MiniVisitsTrends extends Report
{

    function GetReportData()
    {
        global $reports;

        $r = new $reports['_VISITORS_PER_DAY']['ClassName']();
        $r->IgnReIm = 1;
        $r->from = $this->from;
        $r->to = $this->to;
        $data = $r->GetReportData();

        $trend = [];
        $visits = 0;

        foreach ($data as $row => $col) {
            $trend[] = $col[4];
        }

        $t_line = round($this->CalcTrendData($trend));

        $daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(
                implode($this->profile->dateFormat),
                $this->to
            );

        $result = [
            _VISITS_TRENDS            # Label
        ,
            number_format($t_line) # Number to display
        ,
            '_TREND_ANALYSIS'        # Report label to load
        ];

        if ($t_line > 0) {
            $result[1] = "+{$result[1]}";
            $result[3] = "ion-arrow-graph-up-right";
            $result[4] = "bg-green";
        } else {
            $result[3] = "ion-arrow-graph-down-right";
            $result[4] = "bg-red";
        }

        $result[5] = $daterange . "<br/>" . _MINI_VISITS_TRENDS_DESC;

        return $result;
    }

    function CalcTrendData($data)
    {
        $a = 0;
        $c = 0;

        $bx = 0;
        $by = 0;

        foreach ($data as $k => $v) {
            $a = $a + ($k * $v);
            $bx += $k;
            $by += $v;

            $c = $c + pow($k, 2);
        }


        $a = $a * count($data);
        $c = $c * count($data);
        $b = $bx * $by;
        $d = pow($bx, 2);

        if (($c - $d) <= 0) {
            $result = 0;
        } else {
            $result = ($a - $b) / ($c - $d);
        }

        return $result;
    }
}

