<?php

/**
 * @desc This report displays the browser versions
 */

$reports["_BROWSERS_BY_COUNTRY"] = [
    "ClassName" => "BrowsersByCountry",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/browser_versions.png",
    "Options" => "daterangeField,displaymode,profileselector,country_list,trafficsource,limit,columnSelector",
    "Filename" => "browsers_by_country",
    "Distribution" => "Premium",
    "Order" => 3,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false
];

class BrowsersByCountry extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "sunburst";
        $this->DisplayModes = "sunburst,drilldown,table";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }

        $this->columnDefinitions[] = ["Label" => "_COUNTRY", "search" => true];
        $this->columnDefinitions[] = ["Label" => "_BROWSER"];
        $this->columnDefinitions[] = ["Label" => "_BROWSER_VERSION", "dataType" => "String"];

        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "_SUM_DAILY_UNIQUE_VISITORS"];
        $this->columnDefinitions[] = ["Label" => "key", "display" => false];
        //$this->columnDefinitions[] = array("Label" => "_TRENDS");

        $this->sort = false; // we do custom sorting for this report
        $this->key_col = 5;

        //$this->trendlink = "<a class='open_in_new_dialog' type='_BROWSER_TRENDS' rel='BrowserTrends' href='reports.php?conf={$this->profile->profilename}&amp;labels=_BROWSER_TRENDS&amp;country_name=%country'><i class='fa fa-line-chart' style='float:right' data-report='_BROWSER_TRENDS' data-country='%country'></i></a>";

        $this->trendlink = "<i class='fa fa-line-chart open_in_new_dialog' style='float:right' type='_BROWSER_TRENDS' rel='BrowserTrends' href='reports.php?conf={$this->profile->profilename}&amp;labels=_BROWSER_TRENDS&amp;country_name=%country&amp;from={$this->from}&amp;to={$this->to}'></i></a>";
        if ($this->labels == "_AG_BROWSERS_BY_COUNTRY") {
            $this->trendlink = "<i class='fa fa-line-chart open_in_new_dialog' style='float:right' type='_AG_BROWSER_TRENDS' rel='AggregatorBrowserTrends' href='reports.php?conf={$this->profile->profilename}&amp;labels=_AG_BROWSER_TRENDS&amp;country_name=%country&amp;from={$this->from}&amp;to={$this->to}&amp;profilelist={@$this->profilelist}'></i></a>";
        }
        if (!isset($this->limit)) {
            $this->limit = 10;
        }
        $this->report_limit = $this->limit;
    }

    function DefineQuery()
    {
        global $db;

        $ingnore = "AND ua.name != '-' ";
        $ingnore .= "AND ua.name != '0' ";
        $ingnore .= "AND ua.name != '()' ";


        $query = subsetDataToSourceID(
            "SELECT country, ua.name AS useragent, concat(ua.name,' ',ua.version), COUNT(distinct a.sessionid) AS visits, COUNT(distinct a.visitorid) AS visitors, MD5(CONCAT(country,ua.name,ua.version)) AS bv FROM {$this->profile->tablename} as a,{$this->profile->tablename_useragents} as ua where a.useragentid = ua.id and a.timestamp >= " . $db->quote(
                $this->from
            ) . " AND a.timestamp <=" . $db->quote(
                $this->to
            ) . " {$ingnore} GROUP BY bv, a.country, ua.name, ua.version ",
            $this->trafficsource
        );
        $query .= "ORDER BY country ASC, visits DESC";

        $this->applytrafficsource = false;

        return $query;
    }

    function DisplayReport()
    {
        $data = $this->GetReportData();
        //dump($data);
        $this->ReportHeader();
        $this->displayHeader = false;

        if (empty($data)) {
            echoNotice(_NO_DATA_FOR_THIS_DATE_RANGE, "margin: 10px;");
            return false;
        }
        if ($this->displaymode == "drilldown") {
            $collapsekeys = [0, 1, 2];
            $sumkeys = [3, 4];

            $this->CollapseTable($data, $collapsekeys, $sumkeys);
            return;
        }
        if ($this->displaymode == "sunburst") {
            $this->collapsekeys = [0, 1, 2];
            $this->sumkeys = [3, 4];

            $this->Sunburst($data);
            return;
        }

        $this->limit = 10000;
        $this->paginationPanel = true;
        $this->Table($data);
    }

    function GetReportData()
    {
        $this->limit = 10000;
        $data = parent::GetReportData();
        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }
}


