<?php

/**
 * @desc This report displays the browser market share
 */

$reports["_BROWSER_MARKET_SHARE"] = [
    "ClassName" => "BrowserMarketShare",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/browsers.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,limit",
    "Filename" => "browser_market_share",
    "Distribution" => "Standard",
    "Order" => 1,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "Update" => false
];

class BrowserMarketShare extends report
{

    function Settings()
    {
        $this->DefaultDisplay = "pie";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_BROWSER"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->key_col = 0;
        $this->sort_key = 1;
        $this->sort_order = SORT_DESC;
    }

    function GetReportData()
    {
        global $reports;
        $r = new $reports["_BROWSER_VERSIONS"]["ClassName"]();
        # Reset to default report settings
        $r->sort = false;
        $r->sort_key = 0;
        $r->key_col = 0;

        $r->columnDefinitions = $this->ResetColumns();
        $r->setupColumnDefinitions();
        $data = $r->GetReportData();
        $data = $this->DataGroupBy($data, 0);
        $data = DataSort($data, 1);
        return $data;
    }

    function ResetColumns()
    {
        return [
            ["Label" => "_BROWSER"],
            ["Label" => "_BROWSER_VERSION", "display" => false],
            ["Label" => "_VISITS"],
            ["Label" => "_UNIQUE_VISITORS", "display" => false],
            ["Label" => "key", "display" => false],
        ];
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}


