<?php

/**
 * @desc Definitions for this report: Visitors per Day
 * Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
 * Pageviews: The total number of pages requested (excluding any bots and crawlers).
 * Average Pages per user: The total number of pages devided by the number of visitors.
 */
$reports["_VISITORS_PER_DAY"] = [
    "ClassName" => "VisitorsPerDay",
    "Category" => "_VISITOR_TRENDS",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,displaymode,trafficsource,profileselector,columnSelector,human",
    "Filename" => "visitors_per_day",
    "Distribution" => "Standard",
    "Order" => 2,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class VisitorsPerDay extends Report
{
    function Settings()
    {
        $this->DisplayModes = "table,linechart,barchart";
        $this->DefaultDisplay = "linechart";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }

        $this->sort = false;
        $this->columnDefinitions[] = ["Label" => "_DATE"];
        $this->columnDefinitions[] = ["Label" => "_UNIQUE_VISITORS", "line_order" => 0];
        if (!isset($this->pageviews)) {
            $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS", "line_order" => 2, "disable_line" => "true"];
        } else {
            $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS", "line_order" => 2, "disable_line" => "false"];
        }
        $this->columnDefinitions[] = [
            "Label" => "_PAGES_PER_USER",
            "totalRow" => "avg",
            "disable_line" => "true",
            "line_order" => 3,
            "show_line" => false
        ];
        $this->columnDefinitions[] = ["Label" => "_VISITS", "line_order" => 1, "hide_column" => true];
        $this->columnDefinitions[] = [
            "Label" => "_PAGES_PER_VISIT",
            "totalRow" => "avg",
            "disable_line" => "true",
            "line_order" => 4,
            "show_line" => false,
            "hide_column" => true
        ];
        $this->barcolors = ["#9ecae1", "#c6dbef"];

        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul><li>' . _VISITORS_DEFINITION . '</li><li>' . _PAGEVIEWS_DEFINITION . '</li><li>' . _AVERAGE_PAGES_PER_USER_DEFINITION . '</li><li>' . _VISITS_DEFINITION . '</li><li>' . _AVERAGE_PAGES_PER_VISIT_DEFINITION . '</li></ul>';
    }

    function DefineQuery()
    {
        global $db;
        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }
        $query = "SELECT FROM_UNIXTIME(timestamp, '%d-%b-%Y %a') AS days, COUNT(DISTINCT visitorid) as visitors, COUNT(*) AS pages, (COUNT(*) / COUNT(DISTINCT visitorid)) AS ppv, COUNT(DISTINCT sessionid) AS visits, (COUNT(*) / COUNT(DISTINCT sessionid)) AS ppvs FROM {$tablename} WHERE timestamp >= " . $db->quote(
                $this->from
            ) . " AND timestamp <= " . $db->quote($this->to) . " GROUP BY days ORDER BY timestamp";

        return $query;
    }


}


