<?php

/**
 * @desc Definitions for this report: User Agents
 *
 * Visitors: The number of visitors with browsers of this type.
 * Browser: the Browser name.
 *
 * Move your mouse over the number of requests, a tooltip will appear containing the percentage share of the selected browser/os.
 * (This works in all reports, by the way ;-) Also check theReport for more browser details.
 */
$reports["_USER_AGENTS"] = [
    "ClassName" => "UserAgents",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/user_agents.png",
    "Options" => "daterangeField,profileselector,trafficsource,limit,columnSelector",
    "hidden" => true,
    "Distribution" => "Premium",
    "Filename" => "user_agents",
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class UserAgents extends Report
{

    function Settings()
    {
        $this->columnDefinitions[] = ["Label" => "_BROWSER"];
        $this->columnDefinitions[] = ["Label" => "_UNIQUE_VISITORS"];
    }

    function DefineQuery()
    {
        global $db;

        $query = "SELECT ua.name AS useragent, COUNT(DISTINCT visitorid) AS visitors FROM {$this->profile->tablename} AS a, {$this->profile->tablename_useragents} as ua WHERE a.useragentid = ua.id AND a.timestamp BETWEEN " . $db->quote(
                $this->from
            ) . " AND " . $db->quote($this->to) . " GROUP BY useragent ORDER BY visitors DESC";

        return $query;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }
}


