<?php

/**
 * @desc Definitions for this report: Total Duration
 *
 * Time Spent: How long do your visitors stay on your site in total (all visits in Date range).
 * Visit Share: The percentage of visitors that fall into this visit time range.
 * Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
 * Average Duration in minutes: The average duration for this visit time range.
 */
$reports["_TOTAL_DURATION"] = [
    "ClassName" => "TotalDuration",
    "Category" => "_VISITOR_DETAILS",
    "icon" => "images/icons/32x32/totalduration.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector,human",
    "Filename" => "total_duration",
    "Distribution" => "Premium",
    "Order" => 3,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class TotalDuration extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "pie";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_TIME_SPENT"];
        $this->columnDefinitions[] = ["Label" => "_VISITORS"];
        $this->columnDefinitions[] = [
            "Label" => "_AVERAGE_DURATION_IN_MINUTES",
            "totalRow" => "weighted-avg",
            "weight-row" => 1
        ];
        $this->columnDefinitions[] = ["Label" => "_VISIT_SHARE"];
        $this->key_col = 4;
        $this->sort_key = 4;

        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul>' . '<li>' . _TIME_SPENT_TOTAL_DEFINITION . '<li>' . _VISITORS_DEFINITION . '<li>' . _AVERAGE_DURATION_DEFINITION . '<li>' . _VISIT_SHARE_DEFINITION . '</ul>';
    }

    function GetReportData()
    {
        global $db, $get_constant;
        $this->createDataFiles($this->from, $this->to);
        $d = $this->getDataFromFiles($this->dataFiles($this->from, $this->to));
        $data = [];
        $tot = 0;
        foreach ($d as $val) {
            $tot = $tot + $val[1];
        }
        $i = 0;

        foreach ($d as $val) {
            $data[$i][0] = (defined(trim($val[0]))) ? constant(trim($val[0])) : $val[0];
            $data[$i][1] = $val[1];
            $data[$i][2] = ($val[1] == 0) ? 0 : ($val[2] / $val[1]) / 60;
            $data[$i][3] = ($tot == 0) ? 0 : ($val[1] / $tot) * 100;
            $data[$i][4] = $val[4];
            $i++;
        }
        return $data;
    }

    function DefineQuery()
    {
        global $db;


        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }
        //we can't do a temporary table in mysql 5, so drop and
        $prequery = "truncate " . $this->profile->tablename_vlength;
        $db->Execute($prequery);
        $prequery = "truncate " . $this->profile->tablename_tlength;
        $db->Execute($prequery);

        $prequery = subsetDataToSourceID(
            "insert into " . $this->profile->tablename_vlength . " select (max(timestamp)-min(timestamp)), visitorid from {$tablename} force index (timestamp) where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote($this->to) . " and status=200 group by sessionid,visitorid ",
            $this->trafficsource
        );
        $db->Execute($prequery);
        $db->Execute(
            "insert into " . $this->profile->tablename_tlength . " select sum(length), visitorid from " . $this->profile->tablename_vlength . " group by visitorid"
        );

        $range = $db->Execute(
            "select min(length), max(length),count(*) from " . $this->profile->tablename_tlength . ""
        );
        $range_data = $range->FetchRow();
        $min = $range_data[0];
        $max = $range_data[1];
        $total_visitors = $range_data[2];
        $blocksize = ($max - $min) / 8;
        $query = "select \"_0_TO_10_SECONDS            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"1\" as ord from " . $this->profile->tablename_tlength . " where length >=0 and length <=10 union ";
        $query .= "select \"_10_TO_60_SECONDS            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"2\" as ord from " . $this->profile->tablename_tlength . " where length >=10 and length <=60 union ";
        $query .= " select \"_1_TO_5_MINUTES            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"3\" as ord from " . $this->profile->tablename_tlength . " where length >=60 and length <=300 union ";
        $query .= "select \"_5_TO_15_MINUTES            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"4\" as ord from " . $this->profile->tablename_tlength . " where length >=300 and length <=900 union ";
        $query .= "select \"_15_TO_30_MINUTES            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"5\" as ord from " . $this->profile->tablename_tlength . " where length >=900 and length <=1800 union ";
        $query .= "select \"_30_TO_1_HOUR            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"6\" as ord from " . $this->profile->tablename_tlength . " where length >=1800 and length <=3600 union ";
        $query .= "select \"_MORE_THAN_1_HOUR            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"7\" as ord from " . $this->profile->tablename_tlength . " where length >=3600";

        $query .= " order by ord";

        $this->applytrafficsource = false;


        return $query;
    }

    function AggregateFixData($data, $num_profiles)
    {
        $tot = 0;
        foreach ($data as $val) {
            $tot = $tot + $val[1];
        }
        foreach ($data as $k => $val) {
            $data[$k][2] = $val[2] / $num_profiles;
            $data[$k][3] = ($tot == 0) ? 0 : ($val[1] / $tot) * 100;
        }
        return $data;
    }
}


