<?php

/**
 * @desc Definitions for this report: Top referrers details
 *
 * Hits: The number of times someone clicked to your site via this referring URL.
 * Referrer: The external referring page, excluding parameters (This page has a link to your site!).
 * Landing Page: A page on your site that was the target of the external link.
 * CAUTION: the Landing Page listed below does not have to be the only page the referrer can link to. A more acturate description would be 'A recent landing page for this referrer'.
 */
$reports["_TOP_REFERRERS_DETAILS"] = [
    "ClassName" => "TopReferrersDetails",
    "Category" => "_TRAFFIC_SOURCES",
    "icon" => "images/icons/32x32/topreferrersdetails.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector,human",
    "Filename" => "top_referrers_details",
    "Distribution" => "Premium",
    "Order" => 3,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "canAggregate" => false
];

class TopReferrersDetails extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_REFERRER", "actionmenu" => 'referrer'];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "_HITS"];
        $this->actionmenu_type = 'referrer';
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul><li>' . _REFERRER_DEFINITION . '<li>' . _VISITS_DEFINITION . '<li>' . _HITS_DEFINITION . ' ' . '<br></ul>';
    }

    function DefineQuery()
    {
        global $applytrafficsource, $nc, $db;

        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $subquery = subsetDataToSourceID(
            "select {$nc} referrer,refparams, count(distinct sessionid) as visits,count(*) as hits, count(distinct visitorid) as visitors from {$tablename} where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote(
                $this->to
            ) . " and status=200 and referrer IN (select id from {$this->profile->tablename_referrers} where internal_referrer = 0) group by referrer,refparams order by visits desc",
            $this->trafficsource
        );
        $this->applytrafficsource = false;

        $query = "select concat(r.referrer,rp.params) as furl, sq.visits, sq.hits, sq.visitors FROM ({$subquery}) as sq, {$this->profile->tablename_referrers} as r, {$this->profile->tablename_refparams} as rp WHERE sq.referrer=r.id and sq.refparams=rp.id";

        return $query;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }


}


