<?php

/**
 * @desc This report displays a overview of your top keywords
 */
$reports["_TOP_KEYWORDS"] = [
    "ClassName" => "TopKeywords",
    "Category" => "_TRAFFIC_SOURCES",
    "icon" => "images/icons/32x32/topkeywords.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector,human",
    "Filename" => "top_keywords",
    "Distribution" => "Premium",
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class TopKeywords extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->actionmenu_type = 'keyword';
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;

        $this->columnDefinitions[] = ["Label" => "_KEYWORDS", "actionmenu" => 'keyword', "search" => true];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];

        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul><li>' . _KEYWORDS_DEFINITION . '</li><li>' . _VISITS_DEFINITION . '</li><li>' . _PAGEVIEWS_DEFINITION . '</li></ul>';
    }

    function DefineQuery()
    {
        global $db, $nc;
        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $emptykeyword = getID('', 'keyword');

        $subquery = subsetDataToSourceID(
            "select {$nc} keywords, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$tablename} where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote(
                $this->to
            ) . " and keywords != '{$emptykeyword}' group by keywords order by visits desc",
            $this->trafficsource
        );

        $this->applytrafficsource = false;

        $query = "select {$nc} k.keywords, sq.visits, sq.hits, sq.visitors from ({$subquery}) as sq, {$this->profile->tablename_keywords} as k where sq.keywords=k.id";

        return $query;
    }
}


