<?php

const _MINI_NEW_VS_RETURNING = _NEW_VS_RETURNING . "&nbsp;";

$reports["_MINI_NEW_VS_RETURNING"] = [
    "ClassName" => "MiniNewVsReturning",
    "Category" => "_KEY_METRIC",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,profileselector",
    "Filename" => "metric_new_returning",
    "Distribution" => "Standard",
    "Order" => 4,
    "ReportVersion" => 6.0,
    "MinimumVersion" => 6.0,
    "Update" => false
];

class MiniNewVsReturning extends Report
{

    function GetReportData()
    {
        global $reports;

        $r = new $reports['_NEW_VS_RETURNING']['ClassName']();
        $r->IgnReIm = 1;
        $r->from = $this->from;
        $r->to = $this->to;
        $report_data = $r->GetReportData();

        $data = [];
        $total = 0;
        $avg = 0;
        $i = 0;

        foreach ($report_data as $day => $vals) {
            $total += $vals[1];
            $i++;
        }

        if ($i == 0) {
            $avg = 0;
        } else {
            $avg = number_format(($total / $i), 2) . "%";
        }

        $daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(
                implode($this->profile->dateFormat),
                $this->to
            );

        return [
            _NEW_VS_RETURNING        # Label
        ,
            $avg                    # Number to display
        ,
            '_NEW_VS_RETURNING'    # Report label to load
        ,
            'ion-android-people'        # Background icon Class
        ,
            'bg-light-blue'
        ,
            "<strong>" . $daterange . "</strong><br/>" . _MINI_NEW_VS_RETURNING_DESC
        ];
    }
}

