<?php

/**
 * @desc This report displays the age of your facebook friends
 */
$reports["_FACEBOOK_PAGEVIEWS"] = [
    "ClassName" => "FacebookAllPageviews",
    "Category" => "_FACEBOOK",
    "icon" => "images/icons/32x32/fb_pageviews.png",
    "Options" => "daterangeField,displaymode",
    "Filename" => "facebook_all_pageviews",
    "Distribution" => "Premium",
    "Order" => 12,
    "ReportVersion" => 4.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class FacebookAllPageviews extends FacebookCore
{

    function Settings()
    {
        parent::Settings();
        $this->DisplayModes = "table,linechart";
        $this->DefaultDisplay = "linechart";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }
        $this->addlabel = _FACEBOOK_PAGEVIEWS_ADDLABEL;
        $this->help = _FACEBOOK_PAGEVIEWS_HELP;

        $this->metric = "pageviews";
        $this->metric_restriction = "all";
    }

    function DisplayGraph()
    {
        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $this->graphID; ?>(container_id, result) {
                if (result.Status == undefined || result.Status != "Success") {
                    return;
                }

                const data = result.data;
                if (!data) {
                    console.log("No data");
                    return;
                }

                // Applications need the data array, pages need the data.values array...
                let data_set = data;
                if (result.type == "[P]") {
                    if (data.values == undefined) {
                        console.log("No data");
                        return;
                    } else {
                        data_set = data.values;
                    }
                }

                const lg_gr_data = [];
                const xticks = [];

                for (let i = 0; i < data_set.length; i++) {
                    const row = data_set[i];

                    if (result.type == "[P]") {
                        var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time));
                    } else {
                        var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.time));
                    }

                    xticks.push(time);

                    if (lg_gr_data[0] == undefined) {
                        lg_gr_data[0] = {
                            key: "<?php echo _PAGEVIEWS; ?>",
                            values: [
                                [i, parseInt(row.value)]
                            ]
                        };
                    } else {
                        lg_gr_data[0].values.push({x: i, y: parseInt(row.value)});
                    }
                }

                $("#" + container_id).attr("data-ticks", JSON.stringify(xticks));
                $("#" + container_id).attr("data-chart", JSON.stringify(lg_gr_data));

                lg.BarChart(container_id);
            }
        </script><?php
    }

    function DisplayTable()
    {
        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $this->graphID; ?>(container_id, result) {
                if (result.Status == undefined || result.Status != "Success") {
                    return;
                }

                let data = result.data;
                if (!data || data === undefined) {
                    console.log("No data");
                    return;
                }

                let data_set = data;
                if (result.type == "[P]") {
                    if (data.values == undefined) {
                        console.log("No data");
                        return;
                    } else {
                        data_set = data.values;
                    }
                }
                data = data_set;

                const dataSet = [];

                const columnSet = [
                    {title: "<?php echo _DATE; ?>"},
                    {title: "<?php echo _PAGEVIEWS; ?>"}
                ];

                for (let i = 0; i < data.length; i++) {
                    const row = data[i];

                    if (result.type == "[P]") {
                        var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time));
                    } else {
                        var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.time));
                    }

                    dataSet.push([time, row.value.toString()]);

                }

                $("#" + container_id).dataTable({
                    data: dataSet,
                    columns: columnSet,
                    "iDisplayLength": dataSet.length,
                    "aaSorting": [],
                    "sDom": "t"
                });

            }
        </script><?php
    }
}

?>