<?php

if (!defined('APP_INCLUDE')) {
    die('invalid inclusion');
}

/*
	# For input field
	$data[ LABEL ][ value ] = YOUR VALUE
				  [ type ] = keep empty or 'input'
				  
	# For selector Box		
	$data[ LABEL ][ value ]	= YOUR VALUE
	$data[ LABEL ][ options ][0] = YOUR VALUE
							 [1] = YOUR VALUE
				  [ type ] = 'select'
				  
	# For hidden field
	$data[ LABEL ][ value ] = YOUR VALUE
				  [ type ] = 'hidden'
	
	
*/

class FormGenerator
{
    var $formclass;
    var $editable;
    var $typemerging; /// Default false . when set to true the names and types of a field will be merged in the name with a # tag.
    var $types;

    function __construct()
    {
        $this->types = [
            "input"
        ,
            "password"
        ,
            "select"
        ,
            "hidden"
        ,
            "radio"
        ,
            "checkbox"
        ,
            "textarea"
        ];
        $this->editable = false;
        $this->typemerging = false;
    }

    function CreateForm($data, $class = 'custom-form', $method = 'POST', $target = '')
    {
        $this->formclass = $class;
        echo "<div class='{$class}'><form method='{$method}' action='{$target}'>";

        $group = "form";
        if ($this->editable == true) {
            $group = "input";
        }

        foreach ($data as $k => $v) {
            echo "<div class='col-xs-12 col-sm-5 custom-group t-{$v['type']}'>";
            if ($v['type'] != 'hidden' && $v['type'] != 'submit' && $v['type'] != 'button') {
                echo "<label for='{$this->formclass}-{$k}'>{$k}</label>";
            }
            echo "<div class='$group-group'>";
            $this->CreateField($k, $v);
            echo "</div>";
            echo "</div>";
        }
        if ($this->editable == true) {
            echo "<div class='custom-group'>";
            echo "<div class='$group-group'>";
            echo "<button class='btn btn-xs add-field'>Add New Element</button>";
            echo "</div>";
            echo "</div>";
        }
        echo "</form></div>";
    }

    function CreateField($label, $values)
    {
        if ($this->typemerging == true && isset($values['type'])) {
            $this->fieldName = $label . "#" . $values['type'];
        } else {
            $this->fieldName = $label;
        }

        if (empty($values['type']) || $values['type'] == 'input') {
            $this->InputField($label, $values['value']);
        } else {
            if ($values['type'] == 'select') {
                $this->SelectBox($label, $values['options'], $values['value']);
            } else {
                if ($values['type'] == 'hidden') {
                    $this->HiddenField($label, $values['value']);
                } else {
                    if ($values['type'] == 'radio') {
                        $this->RadioField($label, $values['value']);
                    } else {
                        if ($values['type'] == 'checkbox') {
                            $this->CheckBoxField($label, $values['value']);
                        } else {
                            if ($values['type'] == 'password') {
                                $this->PasswordField($label, $values['value']);
                            } else {
                                if ($values['type'] == 'textarea') {
                                    $this->TextField($label, $values['value']);
                                } else {
                                    if ($values['type'] == 'button') {
                                        $this->Button($label, $values['value']);
                                    } else {
                                        if ($values['type'] == 'submit') {
                                            $this->SubmitButton($label, $values['value']);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    function InputField($label, $value)
    {
        echo "<input class='form-control' type='text' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />";
        echo $this->DeleteBtn();
    }

    function DeleteBtn($rel = "")
    {
        return (!$this->editable) ? "" : "<span class='input-group-addon'><i title='Remove this Element' rel='$rel' class='remove-field fa fa-times' style='width:16px;' ></i></span>";
    }

    function SelectBox($label, $fields, $selected)
    {
        echo "<select class='form-control' id='{$this->formclass}-{$label}' name='{$this->fieldName}'>";
        foreach ($fields as $k => $v) {
            $sel = '';
            if ($v == $selected) {
                $sel = "selected='selected'";
            }
            echo "<option value='{$v}' $sel>{$v}</option>";
        }
        echo "</select>";
        echo $this->DeleteBtn("{$this->formclass}-{$label}-hidden");
        echo "<input type='hidden' value='" . implode(",", $fields) . "' name='{$this->fieldName}#options' />";
    }

    function HiddenField($label, $value)
    {
        echo "<input type='hidden' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />";
    }

    function RadioField($label, $value)
    {
        echo "<input class='form-control' type='radio' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />{$value}";
        echo $this->DeleteBtn();
    }

    function CheckBoxField($label, $value)
    {
        echo "<input type='checkbox' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />{$value}";
        echo $this->DeleteBtn();
    }

    function PasswordField($label, $value)
    {
        echo "<input class='form-control' type='password' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />";
        echo $this->DeleteBtn();
    }

    function TextField($label, $value)
    {
        echo "<textarea class='form-control' id='{$this->formclass}-{$label}' name='{$this->fieldName}'>{$value}</textarea>";
        echo $this->DeleteBtn();
    }

    function Button($label, $value)
    {
        echo "<input class='form-control' type='button' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />";
    }

    function SubmitButton($label, $value)
    {
        echo "<input class='form-control btn btn-success' type='submit' id='{$this->formclass}-{$label}' name='{$this->fieldName}' value='{$value}' />";
    }

    function JqueryScript($select = "body")
    {
        ?>
        <script type='text/javascript'>
            const typemerging = '<?php echo $this->typemerging; ?>';


            function field_prompter() {
                const new_label = prompt("What is the label of your new field?", "");
                if (new_label == "") {
                    return false;
                }

                const new_type = prompt("What is the type of your new field?\n(<?php echo implode(
                    ",",
                    $this->types
                ); ?>)", "");


                let name = new_label;
                if (typemerging == 1) {
                    name = new_label + "#" + new_type;
                }

                if (new_type == 'select') {
                    const new_options = prompt("What do you want your options to be?\n (separate options with ',' example: red,blue,etc..");
                    const options = new_options.split(",");
                    let insertfield = "<div class='custom-group t-select'><label>" + new_label + "</label><div class='form-group'><select name='" + name + "'>";
                    for (i = 0; i < options.length; i++) {
                        insertfield = insertfield + "<option value='" + options[i] + "'>" + options[i] + "</option>";
                    }
                    insertfield = insertfield + "</select>";
                    insertfield = insertfield + "<input type='hidden' value='" + new_options + "' name='" + name + "#options' /></div>";


                    $("<?php echo $select ?> form").prepend(insertfield);
                }


                if (new_type == 'input') {

                    $("<?php echo $select ?> form").prepend("<div class='custom-group t-input'><label>" + new_label + "</label><div class='form-group'><input name='" + name + "' type='text' /></div></div>");
                } else if (new_type == 'radio') {
                    $("<?php echo $select ?> form").prepend("<div class='custom-group t-radio'><label>" + new_label + "</label><div class='form-group'><input name='" + name + "' type='radio' /></div></div>");
                } else if (new_type == 'password') {
                    $("<?php echo $select ?> form").prepend("<div class='custom-group t-password'><label>" + new_label + "</label><div class='form-group'><input name='" + name + "' type='password' /></div></div>");
                } else if (new_type == 'checkbox') {
                    $("<?php echo $select ?> form").prepend("<div class='custom-group t-checkbox'><label>" + new_label + "</label><div class='form-group'><input name='" + name + "' type='checkbox' /></div></div>");
                } else if (new_type == 'hidden') {
                    $("<?php echo $select ?> form").prepend("<div class='custom-group t-hidden'><label>" + new_label + "</label><div class='form-group'><input name='" + name + "' type='hidden' /></div></div>");
                } else if (new_type == 'textarea') {
                    $("<?php echo $select ?> form").prepend("<div class='custom-group t-textarea'><label>" + new_label + "</label><div class='form-group'><textarea  name='" + name + "'></textarea></div></div>");
                } else {
                    return false;
                }

            }

            $(document).ready(function () {
                $("<?php echo $select ?>").on("click", ".remove-field", function () {
                    const result = confirm("Are you sure you want to remove this field?");
                    if (result) {
                        $(this).closest('.custom-group').remove();
                    }
                });

                $("<?php echo $select ?>").on("click", ".add-field", function (e) {
                    e.preventDefault();
                    field_prompter();
                });
            });
        </script><?php
    }
}

?>