<?php

// $accessControl = array(
// 	"ProfileRequired" => true
// );
//header('Content-Type: text/html; charset=UTF-8');
require_once '../../AccessControl.php';
include "index.php";

$dashboards = [];
$categories = [];

# Loop through the dashboards
foreach ($profile->dashboards as $k => $v) {
    $dash = json_decode($v["Value"], true);
    if (!isset($dash["name"])) {
        // this dash is messed up, get rid of it
        unset($profile->dashboards[$k]);
        $profile->Save();
        continue;
    }
    $dash["label"] = $dash["name"];
    if (!$session->isAdmin()) {
        if (isset($dash["private"])) {
            if ($session->userinfo['userid'] != $dash["userid"]) {
                continue;
            }
        }
    }
    $dashboards[$dash["name"]] = $dash;
}

# Now add the reports to the data
foreach ($reports as $label => $report) {
    # Add a name key to the reports array
    $reports[$label]["name"] = constant($label);

    if (isset($report['hidden']) && $report['hidden'] == true) {
        continue;
    }

    if (!empty($report['Category'])) {
        $cat = $report['Category'];

        $categories[$cat]['name'] = constant($cat);
        $categories[$cat]['data'][$label] = constant($label);
    }
}

$dateformat = GetCustomDateFormat("JS");
# Echo result
if (isset($cm)) {
    $subscriptions_url = $cm->subscriptions_url;
} else {
    $subscriptions_url = "";
}

//do this to reduce the data we need to send
$profile->filehistory = "";

$str = json_encode([
                       'languages' => $lang_labels,
                       'profiles' => $plist,
                       'pcount' => $pcount,
                       'available_langs' => $available_langs,
                       'lang' => $lang,
                       'getdatafromstore' => $getdatafromstore,
                       'session' => $session,
                       'hl' => $hl,
                       'ss' => $ss,
                       'conf' => $_REQUEST["conf"],
                       'categories' => $categories,
                       'reports' => $reports,
                       'dashboards' => $dashboards,
                       'dateformat' => $dateformat,
                       'profile' => $profile,
                       'version_check' => $must_load_version_check,
                       'from_date' => $from,
                       'to_date' => $to,
                       //'minimumDate' => date( implode($profile->dateFormat) , $from),
                       //'maximumDate' => date( implode($profile->dateFormat) , $to),
                       'minimumDate' => LogaDate($profile->dateFormat, $from),
                       'maximumDate' => LogaDate($profile->dateFormat, $to),
                       'subscriptions_url' => $subscriptions_url
                   ]);
ob_start();
echo $str;
print_gzipped_output();
