<?php

//header('Content-Type: text/html; charset=UTF-8');
$accessControl = [
    "ProfileRequired" => true
];
require_once "../../AccessControl.php";
include "index.php";

$menu_items = [];
$menu_cat = [];

if ($conf == 'newcnf') {
    $profile = new Siteprofile();
    $new = 1;
} else {
    $new = 0;
}

if (isset($session->metadata["accessBasicEditProfile"]) && $session->metadata["accessBasicEditProfile"] == 1) {
    $limited = true;
} else {
    $limited = false;
}


# define the menu categories
$menu_cat["_GENERAL"] = ["text" => _GENERAL, "icon" => " fa-edit"];

if (!$new) {
    $menu_cat["_TRACKING"] = ["text" => _TRACKING, "icon" => " fa-crosshairs"];
    $menu_cat["_REPORTING"] = ["text" => _REPORTING, "icon" => "fa-bar-chart-o"];
    if (!$limited && isset($session)) {
        if ($session->canEditProfiles() && $session->canUpdateLogs()) {
            $menu_cat["_DATA"] = ["text" => _DATA, "icon" => "fa-archive"];
            $menu_cat["_UPDATING"] = ["text" => _UPDATING, "icon" => "fa-download"];
        }
    }
}

# define the menu items
$menu_items["_PROFILE_INFO"] = ["text" => _PROFILE_INFO, "action" => "p.ProfileInfo()", "cat" => "_GENERAL"];
if (!$limited && isset($session)) {
    if ($session->canEditProfiles() && $session->canUpdateLogs()) {
        $menu_items["_DATA_COLLECTION"] = [
            "text" => _DATA_COLLECTION,
            "action" => "p.DataCollection()",
            "cat" => "_GENERAL"
        ];
    }
}
$menu_items["_DATA_FILTERS"] = ["text" => _DATA_FILTERS, "action" => "p.DataFilters()", "cat" => "_GENERAL"];
if (!$limited) {
    $menu_items["_VISITOR_IDENTIFICATION"] = [
        "text" => _VISITOR_IDENTIFICATION,
        "action" => "p.VisitorID()",
        "cat" => "_GENERAL"
    ];
}

if (!$new) {
    $menu_items["_KPI"] = ["text" => _KPI, "action" => "p.KPIs()", "cat" => "_TRACKING"];
    $menu_items["_FEEDS"] = ["text" => _FEEDS, "action" => "p.Feeds()", "cat" => "_TRACKING"];
    $menu_items["_DYNAMIC_PAGES"] = [
        "text" => _DYNAMIC_PAGES,
        "action" => "p.DynamicPages()",
        "cat" => "_TRACKING"
    ];
    if (!$limited) {
        $menu_items["_EXIT_CLICKS"] = ["text" => _EXIT_CLICKS, "action" => "p.ExitClicks()", "cat" => "_TRACKING"];
    }
    //custom events still needs content
    //$menu_items["_CUSTOM_EVENTS"] = array("text" => _CUSTOM_EVENTS, "action" => "p.CustomEvents()", "cat" => "_TRACKING");

    $menu_items["_DATE_TIME"] = ["text" => _DATE_TIME, "action" => "p.DateTime()", "cat" => "_REPORTING"];
    $menu_items["_EMAIL_ALERTS"] = ["text" => _EMAIL_ALERTS, "action" => "p.EmailAlerts()", "cat" => "_REPORTING"];
    if (!$limited && isset($session)) {
        $menu_items["_INPAGE_ANALYTICS"] = [
            "text" => _INPAGE_ANALYTICS,
            "action" => "p.InpageAnalytics()",
            "cat" => "_REPORTING"
        ];
        if ($session->isAdmin()) {
            $menu_items["_CUSTOM_REPORTS"] = [
                "text" => _CUSTOM_REPORTS,
                "action" => "p.CustomReports()",
                "cat" => "_REPORTING"
            ];
        }
        $menu_items["_DASHBOARDS"] = ["text" => _DASHBOARDS, "action" => "p.Dashboards()", "cat" => "_REPORTING"];

        if ($session->canEditProfiles() && $session->canUpdateLogs()) {
            $menu_items["_DATAMANAGER_SETTINGS"] = [
                "text" => _DATAMANAGER_SETTINGS,
                "action" => "p.DataManager()",
                "cat" => "_DATA"
            ];
            $menu_items["_DATABASE_INFO"] = [
                "text" => _DATABASE_INFO,
                "action" => "p.DatabaseInfo()",
                "cat" => "_DATA"
            ];
            $menu_items["_DELETE_DATA"] = ["text" => _DELETE_DATA, "action" => "p.DeleteData()", "cat" => "_DATA"];
            $menu_items["_EXPORT_DATA"] = ["text" => _EXPORT_DATA, "action" => "p.ExportData()", "cat" => "_DATA"];
        }
    }

    if ($session->canAddProfiles()) {
        $menu_items["_EXPORT_PROFILE_SETTINGS"] = [
            "text" => _EXPORT_PROFILE_SETTINGS,
            "action" => "p.ExportProfile()",
            "cat" => "_DATA"
        ];
    }
    if (!$limited && isset($session)) {
        if ($session->canEditProfiles() && $session->canUpdateLogs()) {
            $menu_items["_AUTOMATION"] = [
                "text" => _AUTOMATION,
                "action" => "p.Automation()",
                "cat" => "_UPDATING"
            ];
            $menu_items["_UPDATE_OPTIONS"] = [
                "text" => _UPDATE_OPTIONS,
                "action" => "p.UpdateOptions()",
                "cat" => "_UPDATING"
            ];
        }
    }
}

# merge menu items into cat array so js can easily loop thru it to make the menu
foreach ($menu_items as $key => $val) {
    $menu_cat[$val['cat']]['data'][$key] = $menu_items[$key];
}


#setup the js tracker code
// $w_path = $_SERVER['PHP_SELF'];
// $wpath = str_replace("/app/model", "", dirname($w_path));
// $prestyle = "style='margin:0px;font-family: Arial, sans-serif; font-size: 11px; white-space: pre-wrap; white-space: -moz-pre-wrap; white-space: -pre-wrap; white-space: -o-pre-wrap; word-wrap: break-word;'";
// $codespace="<pre $prestyle>&lt;!-- /* Logaholic Web Analytics Code */ --&gt;
// &lt;script type=\"text/javascript\"&gt; 
// var lwa = {id:\"$profile->tablename\", server:\"$_SERVER[HTTP_HOST]$wpath\"};
// (function(lwa, a) {
//   lwa.action = a; lwa.server = document.location.protocol + \"//\" + lwa.server + \"/\"; 
//   var lwas = document.createElement('script'); lwas.type = 'text/javascript'; lwas.async = 1;
//   lwas.src = lwa.server + \"lwa2.js\";
//   var l = document.getElementsByTagName('script')[0];
//   l.parentNode.insertBefore(lwas, l);
// })(lwa, 'trackPage');
// &lt;/script&gt;
// </pre>";

// //js tracking for hybrid logs + cookie
// $codespace2 = str_replace(", server", ", trackermode:2, server", $codespace);
include "../../includes/codespace.php";

// code for exitclicks
$trackmode = $profile->trackermode == 1 ? 'js' : 'log';

$exitclicks = "<pre $prestyle>&lt;script type='text/javascript'&gt;<br />LWA_tracking = '{$trackmode}';<br/>if (document.location.protocol==\"https:\") { var ptcl = \"https:\" } else { var ptcl = \"http:\" }
var lwa_server = ptcl + \"//{$_SERVER['HTTP_HOST']}{$wpath}/\"; 
document.write(unescape(\"%3Cscript type='text/javascript' src='\" + lwa_server + \"exitclicks.js'%3E%3C/script%3E\"));<br>&lt;/script&gt;</pre>";

$inpage = "<pre $prestyle>&lt;script type='text/javascript'&gt;
var lg_url = 'https://" . $_SERVER['HTTP_HOST'] . $wpath . "/';
var lg_profile = '{$profile->profilename}';
&lt;/script&gt;
&lt;script type='text/javascript' src='https://" . $_SERVER['HTTP_HOST'] . $wpath . "/inpage.js' &gt;&lt;/script&gt;</pre>";

if ($new) {
    $codespace = $codespace2 = Warning(_SAVE_BEFORE_USING_TRACKER, "margin:10px;");
}

$kpilimit = "";
if (CheckSubscriptionOption('KPI_Limit')) {
    $kpilimit = $session->subscription['KPI_Limit'];
} else {
    if (!$ss && !$hl) {
        $kpilimit = 1;
    }
}
if (isset($cm)) {
    $subscriptions_url = $cm->subscriptions_url;
} else {
    $subscriptions_url = "";
}
//Return the information
$str = [
    'languages' => $lang_labels,
    'profiles' => $plist,
    'pcount' => $pcount,
    'available_langs' => $available_langs,
    'usage_tracking' => $usage_tracking,
    'lang' => $lang,
    'getdatafromstore' => $getdatafromstore,
    'session' => $session,
    'hl' => $hl,
    'ss' => $ss,
    'Status' => 'Success',
    'menu_items' => $menu_items,
    'menu_cat' => $menu_cat,
    'profile' => $profile,
    'codespace' => $codespace,
    'codespace2' => $codespace2,
    'exitclicks' => $exitclicks,
    'kpilimit' => $kpilimit,
    'inpage' => $inpage,
    'new' => $new,
    'upload_dir' => getGlobalSetting("upload_dir", logaholic_dir() . "files/") . $profile->profilename . "/",
    'version_check' => $must_load_version_check,
    'subscriptions_url' => $subscriptions_url
];
ob_start();
//dump($str);
echo json_encode($str, JSON_UNESCAPED_UNICODE);
print_gzipped_output();
