let xmlHttp;
let prevLogfileValue = "";
let hintTimer;

function showHint(str) {
    if (str == undefined) {
        str = prevLogfileValue;
    }

    $(".loglist i.done").hide();
    $(".loglist i.working").show();

    if (hintTimer !== undefined) {
        clearTimeout(hintTimer);
    }
    hintTimer = setTimeout(function () {
        showHintAfterDelay(str);
    }, 500);
}

function showHintAfterDelay(str) {
    if (getTrackermode() == '2') {
        //we are doing ftp checks
        if (str.length == 0) {
            str = document.getElementById("ftpfullpath").value;
            if (str.length == 0) {
                if (document.getElementById("ftpserver").value == "" && document.getElementById("ftpuser").value == "" && document.getElementById("ftppasswd").value == "") {
                    return;
                }
            }
        }
        showFTPHint(str);
        return;
    }

    // make sure we replace windows style slashes with unix style slashes
    str = unixslash(str, 'logfilefullpath');


    let request_url = "app/model/Loghint.php";
    request_url = request_url + "?q=" + escape(str) + "&splitfilter=" + document.getElementById("splitfilter").value + "&splitfilternegative=" + document.getElementById("splitfilternegative").value;
    request_url = request_url + "&sid=" + Math.random()

    $.ajax({
        type: "POST",
        url: request_url,
        success: function (result) {
            $(".loglist i.working").hide();
            $(".loglist i.done").show();

            data = ui.ParseJSON(result);
            ProcessResponse(data);
        }
    });

    prevLogfileValue = str;
}

function stateChanged() {
    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete") {
        $(".loglist i.working").hide();
        $(".loglist i.done").show();

        data = ui.ParseJSON(xmlHttp.responseText);

        ProcessResponse(data);
    }
}

function GetXmlHttpObject() {
    let objXMLHttp = null;
    if (window.XMLHttpRequest) {
        objXMLHttp = new XMLHttpRequest()
    } else if (window.ActiveXObject) {
        objXMLHttp = new ActiveXObject("Microsoft.XMLHTTP")
    }
    return objXMLHttp
}

function showFTPHint(str) {
    $.ajax({
        type: "POST",
        url: "app/model/Loghint.php",
        data: "ftpserver=" + document.getElementById("ftpserver").value + "&ftpuser=" + document.getElementById("ftpuser").value + "&ftppasswd=" + document.getElementById("ftppasswd").value + "&ftpfullpath=" + str + "&splitfilter=" + document.getElementById("splitfilter").value + "&splitfilternegative=" + document.getElementById("splitfilternegative").value + "&ftpmode=" + document.getElementById("ftpmode").value + "&ftpport=" + document.getElementById("ftpport").value,
        success: function (msg) {
            if (msg != "") {

                $(".loglist i.working").hide();
                $(".loglist i.done").show();
                data = ui.ParseJSON(msg);
                ProcessResponse(data);

            }
        }
    });

}

function getTrackermode() {
    return $("#trackermode option:selected").val();
}

function ProcessResponse(data) {


    if (data.Status == "Error") {
        ui.Callout(data);
        return;
    }
    if (data.Status == "Warning") {
        $("#txtHint").html('<div class="alert alert-warning" style="margin-top:30px;"><i class="fa fa-warning"></i>' + data.Message + '</div>');
        return;
    }
    callout = "";
    if (data.Type == 'file') {
        callout = "<div class='callout callout-success' style='margin-bottom:0;'>" + data.Message + "</div>";
    } else if (data.Message != "" && data.Type == 'dir') {
        callout = "<div class='callout callout-danger' style='margin-bottom:0;'>" + data.Message + "</div>";
    } else {
        if (getTrackermode() == '2') {
            callout = "<div class='callout callout-info' style='margin-bottom:0;'>" + document.getElementById("ftpfullpath").value + "</div>";
        } else {
            callout = "<div class='callout callout-info' style='margin-bottom:0;'>" + document.getElementById("logfilefullpath").value + "</div>";
        }

    }

    $("#txtHint").html(callout + '<table id="files_table" class="table"></table>');


    $('#files_table').dataTable({
        "aaSorting": [],
        "filter": false,
        "paging": false,
        "data": data.data,
        "autoWidth": false,
        "columns": [
            {"title": "File name"},
            {"title": "Last Modifiied"},
            {"title": "Size"},
            {"title": "Perms"}
        ]
    });

}
