<?php


$reports["_ZENCART_TAXES"] = [
    "ClassName" => "ZenCartTaxes",
    "Category" => "_ZENCART",
    "icon" => "images/icons/32x32/zencart.png",
    "Options" => "daterangeField,columnSelector,displaymode",
    "Filename" => "zencart_taxes",
    "Distribution" => "Premium",
    "Order" => 9,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class ZenCartTaxes extends Report
{
    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,linechart";
        $this->columnDefinitions[] = ["Label" => _TAX_CLASS];
        $this->columnDefinitions[] = ["Label" => _TAXES];
        $this->columnDefinitions[] = ["Label" => _ORDERS];
        if (empty($this->order_status)) {
            $this->order_status = 0;
        }
        if (empty($this->order_status_name)) {
            $this->order_status_name = _ALL_STATUSSES;
        }
        $this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.zenCartConnect", "");
    }

    function DisplayCustomForm()
    {
        global $session;
        $connection = $this->checkExternalConnection("zenCartConnect");

        echo "<div class='form-group'>";

        if ($connection != false) {
            $query = "SELECT DISTINCT(orders_status_id) AS status_id, `orders_status_name` AS status_name FROM `{$this->tableprefix}orders_status` ORDER BY `orders_status_name` ASC";

            $result = mysql_query($query, $connection);

            echo "<label for='order_status'>" . _ORDER_STATUS . "</label>";
            echo "<input type='hidden' id='order_status_name' name='order_status_name' value='{$this->order_status_name}'>";

            echo "<select id='order_status' name='order_status' class='form-control'>";
            echo "<option value='0'>" . _ALL_STATUSSES . "</option>";
            while ($row = mysql_fetch_assoc($result)) {
                if ($row['status_id'] == $this->order_status) {
                    $selected = ' selected ';
                } else {
                    $selected = '';
                }
                echo "<option {$selected} value='{$row['status_id']}'>{$row['status_name']}</option>";
            }
            echo "</select>";

            echo "<script type='text/javascript'>";
            echo "$('#order_status').change(function() {
					$('#order_status_name').attr('value', $(this).find('option[value=\"' + $(this).val() + '\"]').html());
				});";
            echo "</script>";
        }

        if ($session->canEditProfiles()) {
            echo "<a data-title='" . _VIEW_ZENCART_CONF . "'' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels=_ZENCART_TAXES&action=welcome' class='optionlink open_iframe_window'>" . _VIEW_ZENCART_CONF . "</a>";
        }
        echo "</div>";
    }

    function GetReportData()
    {
        $data = [];
        $import = [];
        $connection = $this->checkExternalConnection("zenCartConnect");
        if ($connection == false) {
            echoNotice($this->SettingsButton() . _CONNECTION_TO_DATABASE_FAILED);
            exit();
        }
        $query = $this->DefineQuery();
        $i = 0;
        $currency = "";
        $result = mysql_query($query, $connection);
        while ($row = mysql_fetch_array($result)) {
            $currency = $row["curr"];
            $data[$i][0] = $row["tax_name"];
            $data[$i][1] = $row["ot_tax"];
            $data[$i][2] = $row["tot_orders"];
            $i++;
        }
        mysql_close($connection);


        if (empty($this->order_status_name)) {
            $this->order_status_name = _ALL_STATUSSES;
        }
        $this->addlabel .= _ORDER_STATUS . ": {$this->order_status_name}";
        $this->addlabel .= " | " . _CURRENCY . ": {$currency}";
        return $data;
    }

    function DefineQuery()
    {
        if ($this->order_status != '0') {
            $sql = " AND o.orders_status = '" . (int)$this->order_status . "'";
        } else {
            $sql = "";
        }

        if (!empty($this->from)) {
            $sql .= " AND DATE(o.date_purchased) >= '" . date('Y-m-d', $this->from) . "'";
        }

        if (!empty($this->to)) {
            $sql .= " AND DATE(o.date_purchased) <= '" . date('Y-m-d', $this->to) . "'";
        }

        $query = "SELECT ot.title as tax_name, 
			SUM(ot.value) AS ot_tax, 
			COUNT(o.orders_id) AS `tot_orders`, 
			(SELECT `code` from {$this->tableprefix}currencies WHERE `value` = 1) as curr 

			FROM `{$this->tableprefix}orders_total` ot LEFT JOIN `{$this->tableprefix}orders` o ON (ot.orders_id = o.orders_id) WHERE ot.class = 'ot_tax' {$sql} GROUP BY ot.title LIMIT {$this->limit}";
        return $query;
    }

    function DefineReport()
    {
        $this->externDbConnectForm("zenCartConnect");
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

