<?php

$reports["_PAGE_SCROLL_DEPTH"] = [
    "ClassName" => "PageScrollDepth",
    "Category" => "_POPULAR_CONTENT",
    "Options" => "daterangeField,profileselector,columnSelector,trafficsource,displaymode,limit",
    "Filename" => "page_scroll_depth",
    "Distribution" => "Premium",
    "Order" => 6,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false
];

class PageScrollDepth extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,linechart,barchart";
        $this->allowDateFormat = false;
        $this->columnDefinitions[] = ["Label" => "_PAGE", "actionmenu" => 'page'];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        $this->columnDefinitions[] = ["Label" => "_NO_SCROLL"];
        $this->columnDefinitions[] = ["Label" => "_SCROLLED"];
        $this->columnDefinitions[] = ["Label" => "_AVG_SCROLL_DEPTH", "bchart" => true, "percentage" => true];
        $this->sort_key = 1;
        $this->sort_order = SORT_DESC;

        global $profile;
        include "includes/codespace.php";
        $this->help = _PAGE_SCROLL_DEPTH_DESC . '<br><br>' . _GIFDATA_REPORT_DESC . "<br><br>" . _REPORT_NEEDS_GIFDATA . " " . _TAG_LOGFILES . "<br><br>" . $codespace2;


        // get logaholic.gif id
        $this->gifid = getID("/logaholic.gif", "urls");
        if ($this->gifid == false) {
            $this->gifid = 'false';
            return false;
        }
    }

    function DefineQuery()
    {
        global $db;

        if ($this->gifid == 'false') {
            return false;
        }

        $q = subsetDataToSourceID(
            "select a.referrer, CONVERT(IF(lg_getparam('sdepth',u.params) >100, 100,lg_getparam('sdepth',u.params)), SIGNED INTEGER) as sdepth from {$this->profile->tablename_gifdata} as a, {$this->profile->tablename_urlparams} as u where a.params=u.id and a.url={$this->gifid} and a.timestamp >= " . $db->quote(
                $this->from
            ) . " AND a.timestamp <= " . $db->quote($this->to) . " and u.params like '%sdepth=%'",
            $this->trafficsource
        );

        $q = "select r.referrer, count(*) hits, SUM(IF(sdepth='0','1',0)) as zero, SUM(IF(sdepth > '0','1',0)) as g1, SUM(IF(sdepth > '0',sdepth,'0')) as g2 from ($q) as a, {$this->profile->tablename_referrers} as r where a.referrer=r.id group by r.referrer order by hits desc";

        $this->applytrafficsource = false;
        return $q;
    }


    function GetReportData()
    {
        $data = parent::GetReportData();
        //dump($data);
        foreach ($data as $k => $v) {
            // trurn the referrer into a page
            $url = parse_url($v[0]);
            $data[$k][0] = $url['path'];
            if (empty($data[$k][0])) {
                $data[$k][0] = $v[0];
            }

            // turn the values into percentages
            $noscroll = intval(($v[2] / $v[1]) * 100);
            $scrolled = 100 - $noscroll;
            $data[$k][2] = $noscroll . "%";
            $data[$k][3] = $scrolled . "%";

            if ($v[3] > 0) {
                $data[$k][4] = $v[4] / $v[3];
            } else {
                $data[$k][4] = 0;
            }
            $data[$k][4] = intval($data[$k][4]);
        }
        //dump($data);
        return $data;
    }


    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }

}

