<?php

$reports["_UTM_BREAKDOWN"] = Array(
	"ClassName" => "UtmBreakdown", 
	"Category" => "_ADVERTISING", 	
	"Options" => "daterangeField,profileselector,displaymode,country_list,limit,columnSelector,human",
	"Filename" => "utm_breakdown",
	"Distribution" => "Premium",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class UtmBreakdown extends Report {

	function Settings() {		

		$this->help=_UTM_BREAKDOWN_DESC."<br><br>"._UTM_DESC;
		$this->DefaultDisplay = "sunburst";
		$this->DisplayModes = "sunburst,drilldown,table";
		if(empty($this->displaymode)) {
  			$this->displaymode = $this->DefaultDisplay;
  		}
  		$this->columnDefinitions[] = array("Label" => "_COUNTRY");
		$this->columnDefinitions[] = array("Label" => "Campaign");
		$this->columnDefinitions[] = array("Label" => "Source");
		$this->columnDefinitions[] = array("Label" => "Meduim");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");		
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "key", "display" => false);

		$this->sort=false; // we do custom sorting for this report
		$this->key_col = 6;

		if (isset($this->country_list)) {
			$this->addlabel .= $this->country_list;
		}

		if (!isset($this->limit)) {
			$this->limit = 10;
		}
		$this->report_limit = $this->limit;

	}

	function DefineQuery() {
		global $db;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$query  = "select country,lg_getparam('utm_campaign',u.params) as camp, lg_getparam('utm_source',u.params) as src, lg_getparam('utm_medium',u.params) as medium, count(*) as hits, count(distinct sessionid) as visits, MD5(concat(a.country,lg_getparam('utm_campaign',u.params),lg_getparam('utm_source',u.params),lg_getparam('utm_medium',u.params))) as ky from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and a.params=u.id and u.params like '%utm_campaign=%' group by ky, a.country,u.params order by hits desc";
		
		return $query;
	}

	function GetReportData() {
		$this->limit = 10000;
		$data = parent::GetReportData();
		return $data;
	}

	function DisplayReport(){		
		
		$data = $this->GetReportData();		
		//dump($data);
		$this->ReportHeader();
		$this->displayHeader = false;		

		if(empty($data)){
			echoNotice(_NO_DATA_FOR_THIS_DATE_RANGE, "margin: 10px;");
			return false;
		}
		if ($this->displaymode == "drilldown") {
			$collapsekeys = array(0, 1, 2, 3);
			$sumkeys = array(4, 5);
			
			$this->CollapseTable($data, $collapsekeys, $sumkeys);			
			return;
		}	
		if ($this->displaymode == "sunburst") {
			
			$this->collapsekeys = array(0, 1, 2, 3);
			$this->sumkeys = array(4, 5);
			
			$this->Sunburst($data);
			return;
		}
		
		$this->limit = 10000;
		$this->paginationPanel = true;
		$this->Table($data);		

	}
	

	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
