<?php

/**
* @desc This report displays the Top click paths
*/
$reports["_TOP_CLICK_PATHS"] = Array(
	"ClassName" => "TopClickPaths", 
	"Category" => "_NAVIGATION", 
	"icon" => "images/icons/32x32/topclickpaths.png",
	"Options" => "daterangeField,limit,profileselector,trafficsource,search,columnSelector",
	"Filename" => "top_click_paths",
	"Distribution" => "Premium",
	"Order" => 3,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"canAggregate" => false
);

class TopClickPaths extends Report {
	
	function Settings() {
		$this->columnDefinitions[] = array("Label" => "_PATH");
		$this->columnDefinitions[] = array("Label" => "_HITS");
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
	}
	
	function DefineQuery() {
		global $db;
        
        @$db->Execute("SET SESSION group_concat_max_len = 65535");
		
		$ServerInfo = $db->ServerInfo(); 
        if ($ServerInfo["version"] < 4.1) {
            echo "<script>  loading.style.visibility=\"hidden\";</script> "._ONLY_WORKS_WITH_MYSQL_4_PLUS.":" .$ServerInfo["description"].$ServerInfo["version"];
            return false;
        } else {
            $query="select trail, count(*) as hits from ";
            $query.=subsetDataToSourceID("(SELECT sessionid, Group_Concat(DISTINCT u.url order by timestamp SEPARATOR ' => ') trail FROM {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (status=200 or status=302) and a.url=u.id group by sessionid) ",$this->trafficsource);
            $query.="as paths group by trail order by hits desc";   
            $applytrafficsource=false;
            //probably best to leave it in the temp table though cus them we can do searches on files that are in the trail, i,.e show all trails that contain url x
        }
		
		return $query;
	}
}
?>
