<?php

/**
* @desc This report displays a overview of referrrer conversion.
*/
$reports["_REFERRER_CONVERSION"] = Array(
	"ClassName" => "ReferrerConversion", 
	"Category" => "_PERFORMANCE",
	"canAggregate" => false,  
	"icon" => "images/icons/32x32/referrerconversion.png",
	"Options" => "daterangeField,profileselector,trafficsource,roadto,search,displaymode,limit,columnSelector",
	"Filename" => "referrer_conversion",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"Update" => false
);

class ReferrerConversion extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "pie,table";
		$this->columnDefinitions[] = array("Label" => "_REFERRER","actionmenu" => 'referrer');
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS");
		$this->columnDefinitions[] = array("Label" => "_CONVERTED_VISITORS", "bchart" => true);
		$this->columnDefinitions[] = array("Label" => "_CONVERSION_RATE");
		$this->datafiles = false;
		if(empty($this->displaymode)) { $this->displaymode = $this->DefaultDisplay; }
	}
	
	function DefineQuery() {
		global $db, $nc;
		
		# DROP The temporary tables so that there wont be any duplication errors
		$db->Execute("DROP TABLE IF EXISTS {$this->profile->tablename}_top_entry_converted");
		$db->Execute("DROP TABLE IF EXISTS {$this->profile->tablename}_entrypages");
		$db->Execute("DROP TABLE IF EXISTS {$this->profile->tablename}_top_entry");
		
		if(empty($this->roadto)){ 
			if ($this->profile->targetfiles) {
				$targets=explode(",",$this->profile->targetfiles);
				$this->roadto = $targets[0];		
			}else{
				return false;
			}			
		}
		if (!$this->roadto) {
			$this->columnDefinitions = [];
			$this->columnDefinitions[] = array("Label" => _INFO);
			$this->setupColumnDefinitions();
            $query = "select \""._CHOOSE_TARGET_FILE."\"";
            return;
        }
        
        # first, get the ID of the target page
        $kpi = getID($this->roadto,"urls");
       
        $top_entry_converted_search="";
        if (!empty($this->search)) {        
            $searchst = $this->SearchMatchingIDs($this->search,"referrer",$this->searchmode,$this->profile->tablename_referrers);
            $top_entry_converted_search = str_replace("and referrer IN", "where entry IN", $searchst);           
        } else {
			$searchst = "";
		}
		$db->Execute("SET SESSION group_concat_max_len = 65535");
        # get the entry referrer of each converted user for a certain KPI, then count the ocurrences
        $entrypages_for_conversion = subsetDataToSourceID("SELECT a.visitorid as cvisitor, SUBSTRING_INDEX(Group_Concat(a.referrer order by a.timestamp),',',1) as entry FROM {$this->profile->tablename} as a, {$this->profile->tablename_conversions} as c where (c.timestamp >=". $db->quote($this->from) ." and c.timestamp <=". $db->quote($this->to) .") and (a.timestamp >=". $db->quote($this->from) ." and a.timestamp <= c.timestamp) and c.url='$kpi' and c.visitorid=a.visitorid group by a.visitorid", $this->trafficsource);
        $converted = "create temporary table {$this->profile->tablename}_top_entry_converted SELECT $nc entry, count(distinct cvisitor) as conversions from ($entrypages_for_conversion) as cvisitors $top_entry_converted_search group by entry order by conversions desc";
        $db->Execute($converted);
        
        # next, get the entry referrer for each visitor
        $entrypages = "create temporary table {$this->profile->tablename}_entrypages ". subsetDataToSourceID("SELECT $nc visitorid, SUBSTRING_INDEX(Group_Concat(referrer order by timestamp),',',1) as referrer FROM {$this->profile->tablename} where (timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) .") group by visitorid", $this->trafficsource);
        $db->Execute($entrypages);
         
        # now count the top entry referrers
        $toppages = "create temporary table {$this->profile->tablename}_top_entry SELECT $nc referrer, count(distinct visitorid) as visitors from {$this->profile->tablename}_entrypages, {$this->profile->tablename}_top_entry_converted where entry=referrer {$searchst} group by referrer order by visitors desc limit ". $this->limit;
        $db->Execute($toppages);
		
        # now join it all together
		if($this->displaymode == 'pie') {
			$query = "select $nc r.referrer, conversions, visitors, CONCAT(FORMAT((conversions/visitors)*100,2),' %') as crate from {$this->profile->tablename}_top_entry as a LEFT JOIN {$this->profile->tablename}_top_entry_converted as b on (b.entry=a.referrer) LEFT JOIN {$this->profile->tablename_referrers} as r on (r.id=a.referrer) order by visitors desc";
		} else {
			$query = "select $nc r.referrer, visitors, conversions, CONCAT(FORMAT((conversions/visitors)*100,2),' %') as crate from {$this->profile->tablename}_top_entry as a LEFT JOIN {$this->profile->tablename}_top_entry_converted as b on (b.entry=a.referrer) LEFT JOIN {$this->profile->tablename_referrers} as r on (r.id=a.referrer) order by visitors desc";
		}
        $applytrafficsource = false;

		return $query;
	}
		
	function UpdateStats($from = '', $to = '',$print = 2) {
		# we need actual uniques for this report, so don't update datafiles
		return false;
	}
}
?>
