<?php

/**
* @desc This report displays a your overall performance
*/
$reports["_OVERALL_PERFORMANCE"] = Array(
	"ClassName" => "OverallPerformance", 
	"Category" => "_PERFORMANCE",
	"canAggregate" => false,  
	"icon" => "images/icons/32x32/conversion.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector",
	"Filename" => "overall_performance",
	"Distribution" => "Standard",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class OverallPerformance extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,bubble";
		
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_REQUESTS");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS");
		$this->columnDefinitions[] = array("Label" => "_CONVERSION");
		$this->bubblefields = _UNIQUE_VISITORS.','._CONVERSION.','._REQUESTS.','._PAGE;		
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;
		
		$this->actionmenu_type = 'page';
	}
	
	function DefineQuery() {
		global $db;
		
		$query = subsetDataToSourceID("select count(distinct visitorid) from {$this->profile->tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ."", $this->trafficsource);
		
		$prequery= $db->Execute($query);
		$ptot=$prequery->FetchRow();
		$this->addlabel .= "Total visitors $ptot[0]";
		$query  = "select u.url,count(*) as hits,count(distinct visitorid),((count(distinct visitorid)*1.00)/{$ptot[0]})*100 as ctr from {$this->profile->tablename_conversions} as a,{$this->profile->tablename_urls} as u where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and a.url=u.id group by a.url, u.url order by hits desc";
		
		return $query;
	}
	
	function DisplayReport() {
		
		if (empty($this->profile->targetfiles)) {
			$this->ReportHeader();
			echoNotice(_REPORT_NEEDS_KPI. "<br/><br/><a href='profile.php?conf={$this->profile->profilename}#_KPI' class='btn btn-default'>". _EDIT_PROFILE .": ". _KPI ."</a>", "margin:10px;");
			return;
		}
		
		$this->GetReportData(); // this is done so we have daily datafiles. these are used in performance trends
		$data = $this->GetDataFromDb(); // for this report we need to get it form the database directly, sonce we are counting uniques over mutiple days
		$return = [];
		if(!is_array($data) ) {
			if($data !== false){
				while ( $row = $data->FetchRow() ) {
					$return[] = $row;
				}
			}
		} else {
			foreach ( $data as $row ) {
				$return[] = $row;
			}
		}
		
		if($this->displaymode == "bubble") {
				$this->displayReportButtons = false;		
								
				$this->BubbleChart($data);
		} else {
			$this->reportHeader();
			$this->Table($return);
		}
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		// # we need actual uniques for this report, so don't update datafiles
		return false;		
	}
}
?>
