<?php

/**
* @desc Definitions for this report: Visitors per Day

    Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
    Pageviews: The total number of pages requested (excluding any bots and crawlers).
    Average Pages per user: The total number of pages devided by the number of visitors.
*/

$reports["_MOBILE_VS_DESKTOP"] = Array(
	"ClassName" => "MobileVsDesktop", 
	"Category" => "_CLIENT_SYSTEM", 
	"icon" => "images/icons/32x32/visitorsperday.png",
	"Options" => "daterangeField,profileselector,columnSelector,displaymode",
	"Filename" => "mobile_vs_desktop",
	"Distribution" => "Premium",
	"Order" => 9,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,	
);

class MobileVsDesktop extends Report {
	
	function Settings(){
		$this->DefaultDisplay = "areachart";
		$this->DisplayModes = "table,linechart,areachart";
		$this->columnDefinitions[] = array("Label" => "_DATE");
		$this->columnDefinitions[] = array("Label" => "_MOBILE");
		$this->columnDefinitions[] = array("Label" => "_DESKTOP");
		
		$this->sort = false;
		$this->key_col = 0;
		
		$this->chartoptions = array("stacked_graph_style" => "expand", "stacked_showcontrols" => true, "showlegend" => true);		

	}
	
	function DefineQuery() {
		global $db;
		$query = "SELECT FROM_UNIXTIME(timestamp, '%d-%b-%Y %a') AS days, 
		SUM(CASE WHEN u.is_mobile > 0 THEN 1 ELSE 0 END) as mobile,
		SUM(CASE WHEN u.is_mobile = 0 THEN 1 ELSE 0 END) as desktop from {$this->profile->tablename},{$this->profile->tablename_useragents} as u  WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." and useragentid=u.id GROUP BY days ORDER BY timestamp";
		//echoWarning($query);
		//exit();
		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>