<?php

/**
 * @desc This report displays athe mobile agents
 */
$reports["_MOBILE_DEVICES"] = array(
    "ClassName" => "MobileDevices",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/mobileuseragents.png",
    "Options" => "daterangeField,profileselector,limit,columnSelector",
    "Filename" => "mobile_devices",
    "Distribution" => "Premium",
    "Order" => 11,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "Update" => false
);

class MobileDevices extends Report
{

    function Settings()
    {
        $this->columnDefinitions[] = array("Label" => "_DEVICE");
        $this->columnDefinitions[] = array("Label" => "_VISITS");
        $this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
    }

    function GetColumnDefs()
    {
        return array(
            array("Label" => "_DEVICE")
        ,
            array("Label" => "_VISITS")
        ,
            array("Label" => "_PAGEVIEWS")
        );
    }

    function DisplayReport()
    {
        $this->reportHeader();
        $d = $this->GetReportData();
        $data = [];
        foreach ($d as $k => $v) {
            $v[0] = $this->AddDeviceImage($v[0], $v[3]);
            $data[] = $v;
        }
        $this->Table($data);
    }

    function GetReportData()
    {
        global $reports;
        $r = new $reports["_MOBILE_AGENTS"]["ClassName"]();
        $r->columnDefinitions = $this->columnDefinitions;
        $r->sort_order = SORT_DESC;
        $r->sort_key = 0;
        $r->key_col = 4;
        $r->createDataFiles($this->from, $this->to);
        $data = $r->GetDataFromFiles($r->DataFiles($this->from, $this->to));

        $newdata = [];

        foreach ($data as $k => $v) {
            if (empty($v[4])) {
                continue;
            }
            $newdata[$v[4]][0] = $v[4];
            $newdata[$v[4]][1] = $v[0] + isset($newdata[$v[4]][1]);
            $newdata[$v[4]][2] = $v[6] + isset($newdata[$v[4]][2]);
            $newdata[$v[4]][3] = $v[3];
        }

        return $newdata;
    }

    function AddDeviceImage($device, $os)
    {
        $img = $device;

        if (strpos($os, "iOS") !== false) {
            $img = "&nbsp;<i class='fa fa-apple'> </i> $device";
        } else {
            if (strpos($os, "Android") !== false) {
                $img = "&nbsp;<i class='fa fa-android'> </i> $device";
            } else {
                if (strpos($os, "Windows") !== false) {
                    $img = "&nbsp;<i class='fa fa-windows'> </i> $device";
                } else {
                    $img = "&nbsp;<i class='fa fa-tablet'> </i> $device";
                }
            }
        }
        return $img;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}
