<?php

/**
* @desc This report displays a overview of referrrer conversion.
*/

class Aggregator extends Report {

	protected $s;

	function Settings() {
		global $reports;
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,perprofile";
		// $this->help = "";		
		// $this->remove_outputmodes = array("xml","mail");
		$this->allowDateFormat = false;
		
		if (empty($this->agglabel)) {
			$this->agglabel = "_VISITORS_PER_MONTH";
		}
		$this->addlabel .= "<br>Aggregated ".constant($this->agglabel). " data. ";
		if(!empty($this->source)) { $this->addlabel .= " | ". _SEARCH_FOR ." {$this->sourcetype}: {$this->source}"; }
		

	}

	function GetReportData() {
		if ($this->displaymode =="perprofile") {
			return $this->GetReportDataPP($this->agglabel);	
		} else {
			return $this->AggregateReportData($this->agglabel);
		}

	}

	function GetReportDataPP($label) {

		global $reports,$db,$profile;

		$s = new $reports[$label]["ClassName"]();
		$this->columnDefinitions[] = array("Label" => "_PROFILE","dataType" => "String");
		$this->columnDefinitions = array_merge($this->columnDefinitions, $s->columnDefinitions);
		$this->setupColumnDefinitions();

		$superdata = [];
		if (!empty($this->search)) {
			$search = $this->MakeSearchString($this->search,"profilename",$this->searchmode);			
			$query = $db->Execute("select profilename from `".TBL_PROFILES."` where activated =1 {$search}");
		} else {
			$query = $db->Execute("select profilename from ".TBL_PROFILES."");
		}
		while($data = $query->fetchRow()) {			
			$profile = new SiteProfile($data[0]);
			$r = new $reports[$label]["ClassName"]();
			$r->from = $this->from;
			$r->to = $this->to;
			$r->search = "";			
			
			$data = $r->GetReportData();
			
			if (!empty($data)) {
				//dump($data);
				foreach ($data as $k => $v) {
					array_unshift($v, $r->profile->profilename);
					$data[$k] = $v;
				}
				$superdata = array_merge($superdata, $data);				
			}
			
		}		
		return $superdata;	

	}

	function DisplayReport() {
		global $session;
		
		if (!$session->isAdmin()) {
			echoWarning("Only for admins");
			return;
		}
		if(!isset($_REQUEST['minimumDate'])) {
			echoNotice('This will show visitors per month data for selected profiles. Select a month, search for profiles in the settings or leave blank to list all profiles (be prepared for a long wait)');
			return;
		}
		set_time_limit(86400);
		$data = $this->GetReportData();
		$this->ReportHeader();
		$this->Table($data,$this->from,$this->to,$this->label);	

	}
	
	function DisplayCustomForm() {
	
		echo "<div class='form-group'>";
		echo "<label>Reportlabel</label><input type=text name='agglabel' id='agglabel' class='form-control'>";
		echo "</div>";
	}

	function UpdateStats($from = '', $to = '',$print = 2) {
		# not using datafiles yet
		return false;		
	}
}

?>