<?php


// $conf = "Profiles";  // No profile name here, so we need to set one (otherwise we'll be redirected).
  
include_once("../common.inc.php");
include_once("session.php");
$baseurl = dirname(dirname(currentScriptURL() . "a"))."/"; // strip off the current script name *and* user_login path.


/**
 * User not an administrator, Show an error message.
 */
if ((!$session->isAdmin()) && ($userAuthenticationType != USER_AUTHENTICATION_NONE)) {
  echo $template->NoAccess(_NO_PERMISSION_FOR_ADMIN_AREA. ".<br><a href='index.php'>Click here to continue.</a>");
  exit();
}

if (!isset($_REQUEST["json"])) {
	//include_once "../top.php";
	//echo "<div class=\"indentbody\">\n";
}

# get total number of users
$q = $db->Execute("select count(*) from ".TBL_USERS);
$total_users = $q->FetchRow();
$total_users = $total_users[0];

# get number of user that never logged in
$q = $db->Execute("select count(*) from ".TBL_USERS." where lastlogin=''");
$no_login = $q->FetchRow();
$no_login = $no_login[0];

$active_users = $total_users - $no_login;

$no_login_perc = intval(($no_login / $total_users) * 100);


$response['users'] = array("active_users" => $active_users, "total_users" => $total_users);
if (!isset($_REQUEST["json"])) {
	echo "$no_login users of $total_users total users have never logged in, that's $no_login_perc% !";
}

# get total number of users with profiles
$q = $db->Execute("select count(*) from ".TBL_USERS." where profiles!='' and lastlogin!=''");
$users_wprofiles = $q->FetchRow();
$users_wprofiles = $users_wprofiles[0];

$no_profiles_perc = 100- intval(($users_wprofiles / $active_users) * 100);
if (!isset($_REQUEST["json"])) {
	echo "<br>there are $users_wprofiles users with profiles ($no_profiles_perc% of 'active users' has no profile!)";
}



# get number of user that logged in in the last x days
$intervals[] = 30;
$intervals[] = 60;
$intervals[] = 90;
$intervals[] = 120;
$intervals[] = 150;
$intervals[] = 180;
$intervals[] = 365;
foreach ($intervals as $days) {
	$lastdays = time() - ($days * 86400);
	$q = $db->Execute("select count(*) from ".TBL_USERS." where lastlogin > $lastdays");
	$last = $q->FetchRow();
	$last = $last[0];

	$last_perc = intval(($last / $total_users) * 100);
	$last_perc_active = intval(($last / $active_users) * 100);
	if (!isset($_REQUEST["json"])) {
		echo "<br>Only $last users logged in in the last $days days ($last_perc %)";
		echo "<br>That's $last_perc_active % of active users<br>";
	}
	$response['logged_in_days_ago'][$days] = $last;
}
if (isset($_REQUEST["json"])) {
	echo json_encode($response);
}

?>
