<?php

$reports["_UTM_CAMPAIGNS"] = Array(
	"ClassName" => "UtmCampaigns", 
	"Category" => "_ADVERTISING", 	
	"Options" => "daterangeField,profileselector,displaymode,search,limit,columnSelector,human",
	"Filename" => "utm_campaigns",
	"Distribution" => "Premium",
	"Order" => 4,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class UtmCampaigns extends Report {

	function Settings() {		
		//$this->datafiles=false;
		$this->help=_UTM_DESC;

		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table";
		$this->columnDefinitions[] = array("Label" => "Campaign", "actionmenu" => 'utm_campaign');
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");		
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;

	}

	function DefineQuery() {
		global $db;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$query  = "select lg_getparam('utm_campaign',u.params) as src, count(*) as hits, count(distinct sessionid) as visits from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and a.params=u.id and u.params like '%utm_campaign=%' group by src order by hits desc";
		
		return $query;
	}

	

	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
