<?php

/**
* @desc Definitions for this report: Top Pages

    Hits: The number of times someone clicked to your site using this keyword search.
    Keywords: The keywords that were used to find your site.
    Landing Page: A page on your site that was the target of the external link.
    CAUTION: the Landing Page listed below does not have to be the only page the referrer can link to. A more acturate description would be 'A recent landing page for this keyword'. For more accurate landing pages, check the Top Keyword Details report.
*/
$reports["_TOP_PAGES"] = Array(
	"ClassName" => "TopPages", 
	"Category" => "_POPULAR_CONTENT", 
	"icon" => "images/icons/32x32/toppages.png",
	"Options" => "daterangeField,displaymode,trafficsource,search,limit,profileselector,columnSelector,human",
	"Filename" => "top_pages",
	"Distribution" => "Standard",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class TopPages extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,bubble,pie";
		$this->bubblefields = _VISITS.','._PAGES_PER_VISIT.','._PAGEVIEWS.','._PAGE;
		
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT", "totalRow" => "avg");
		$this->actionmenu_type = 'page';
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._PAGE_DEFINITION.'<li>'._VISITS_DEFINITION.'<li>'._PAGEVIEWS_DEFINITION.'<li>'._AVERAGE_PAGES_PER_VISIT_DEFINITION.'</ul>';
	}
	function GetReportData() {
		global $db, $get_constant;
		$d = parent::GetReportData();
		$data = [];
		$i = 0;

		foreach($d as $val){
			if ($val[0]===0) {
			 	//dump($val);//$i++;
			 	continue;
			}
			$data[$i][0]  = $val[0];
			$data[$i][1]  = $val[1];
			$data[$i][2]  = $val[2];
			$data[$i][3]  = ($val[1] == 0 ? 0 : ($val[2] / $val[1]));
			//$data[$i][3]  = $val[2] / $val[1];
			$data[$i][4]  = $val[4];
			
			$i ++;
		}	

		return $data;
	}
	function DefineQuery() {
		global $nc, $db;
		# idea: these 2 queries have an extra row, secrange, we could use that to estimate unique visitors over arbitrary date ranges by (unique count from the month file / secrange * (from-to))
		//$subquery = subsetDataToSourceID("select {$nc} url,count(distinct sessionid) as visits,count(*) as hits,count(distinct visitorid) as visitors, (max(timestamp) - min(timestamp)) as secrange from {$this->profile->tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." group by url order by visitors desc",$this->trafficsource);
		//$query = "select {$nc} CONCAT(r.url,'##',r.title) as urlinfo, sq.visits, sq.hits, (sq.hits/sq.visitors) as pv, sq.visitors, secrange  from ({$subquery}) as sq, {$this->profile->tablename_urls} as r where sq.url=r.id";
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}
		$subquery = subsetDataToSourceID("select {$nc} url,count(distinct sessionid) as visits,count(*) as hits,count(distinct visitorid) as visitors, (max(timestamp) - min(timestamp)) as secrange from {$tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." group by url order by visitors desc",$this->trafficsource);
		$query = "select {$nc} IF(r.title = '',r.url,CONCAT(r.url,'##',r.title)) as urlinfo, sq.visits, sq.hits, (sq.hits/sq.visitors) as pv, sq.visitors, secrange  from ({$subquery}) as sq, {$this->profile->tablename_urls} as r where sq.url=r.id";
		
		$this->applytrafficsource = false;

		return $query;
	}

}
?>
