<?php

/**
* @desc This report displays a overview of search engines
*/

$reports["_SOCIAL_MEDIA"] = Array(
	"ClassName" => "SocialMedia", 
	"Category" => "_TRAFFIC_SOURCES", 	
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
	"Filename" => "social_media",
	"Distribution" => "Premium",
	"Order" => 11,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class SocialMedia extends Report {

	function Settings() {
		$this->DefaultDisplay = "barchart";
		$this->DisplayModes = "table,pie,barchart";
		$this->columnDefinitions[] = array("Label" => "_SOCIAL_MEDIA");
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_HITS");
		$this->columnDefinitions[] = array("Label" => "_SUM_DAILY_UNIQUE_VISITORS");
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
		$this->key_col = 0;
		$this->chartoptions["reduceXTicks"] = false;
	}

	
	function DefineQuery() {
		global $db;
        
		$query = subsetDataToSourceID("select \"Facebook\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) . " and (r.referrer like \\", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Twitter\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) . " and (r.referrer like \\", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"LinkedIn\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://www.linkedin.com/%\" or r.referrer like \"https://lnkd.in/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Google+\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://plus.google.com/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"YouTube\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://www.youtube.com/%\" or r.referrer like \"https://youtu.be/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Pinterest\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://%.pinterest.com/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Instagram\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://l.instagram.com/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Tumblr\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://t.umblr.com/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Reddit\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://www.reddit.com/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Vkontakte\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://vk.com/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Odnoklassniki\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"https://ok.ru/%\") and a.referrer=r.id union ", $this->trafficsource);

		$query.= subsetDataToSourceID("select \"Weibo\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as uv from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and (r.referrer like \"%weibo.c%\") and a.referrer=r.id ", $this->trafficsource);

        $query.= " order by visits desc";		
        
        $this->applytrafficsource = false;
		
		//echo $query;
		return $query;
	}

	function GetReportData() {
		$d = parent::GetReportData();			
		$data = [];
		$i = 0;
		foreach($d as $k => $v){
			if ($d[$i][1]==0) {
				continue;
			}
			$data[$i][0] = $d[$i][0];
			$data[$i][1] = $d[$i][1];
			$data[$i][2] = $d[$i][2];			
			$data[$i][3] = $d[$i][3];			
			$i ++;
		}
		return $data;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;
	}		
	
}
?>
