<?php

$reports["_OPENCART_SALES"] = Array(
	"ClassName" => "OpenCartSales",
	"Category" => "_OPENCART",
	"icon" => "images/icons/32x32/opencart.png",
	"Options" => "daterangeField,columnSelector,displaymode",
	"Filename" => "oc_sales",
	"Distribution" => "Premium",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);
Class OpenCartSales extends Report{
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,linechart";
		
		$this->columnDefinitions[] = array("Label" => _DATE);
		$this->columnDefinitions[] = array("Label" => _TOTAL_REVENUE);
		$this->columnDefinitions[] = array("Label" => _TAXES);
		$this->columnDefinitions[] = array("Label" => _SHIPPING);		
		$this->columnDefinitions[] = array("Label" => _COMMISSION);		
		$this->columnDefinitions[] = array("Label" => "Coupon");		
		$this->columnDefinitions[] = array("Label" => _SALES);				
		$this->columnDefinitions[] = array("Label" => _ORDERS);		
		
		if(empty($this->period)){ $this->period ='_DAYS'; }
		if(empty($this->order_status)) { $this->order_status = '0'; }
		if(empty($this->oc_store)) { $this->oc_store = '0'; }
		if(empty($this->order_status_name)) { $this->order_status_name = _ALL_STATUSSES; }
		$this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.openCartConnect","");
		
		$this->fileNameExpension .= "." . $this->profile->GetOtherSettings("externalConnection.prefix.openCartConnect", "");
		
	}
	function DisplayCustomForm() {
		global $session;
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection != false){
			#GET STORES
			$query = "SELECT `store_id`,`name` FROM store";
			$result = mysql_query($query, $connection);
			
			echo "<div class='form-group'><label for='oc_store'>".'Store'."</label>";
			
			echo "<select id='oc_store' name='oc_store' class='form-control'>";
			
			echo "<option value='0'>".'Default Store'."</option>";
			while($row = mysql_fetch_assoc($result)) {
				if($row['store_id'] == $this->oc_store) {
					$selected = ' selected ';
				} else {
					$selected = '';
				}
				echo "<option value='{$row["store_id"]}' {$selected}>{$row["name"]}</option>";
			}
			echo "</select>";
			if($session->canEditProfiles()) {
				echo "<a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a>";
			}
			echo "</div>";

			
			# GET ORDER STATUS
			$query = "SELECT DISTINCT(order_status_id) AS status_id, `name` AS status_name FROM `{$this->tableprefix}order_status` ORDER BY `name` ASC";
			
			$result = mysql_query($query, $connection);
			
			echo "<div class='form-group'>";
				echo "<label for='order_status'>"._ORDER_STATUS."</label>";
				echo "<input type='hidden' id='order_status_name' name='order_status_name' value='{$this->order_status_name}'>";
				
				echo "<select id='order_status' name='order_status' class='form-control'>";
					echo "<option value='0'>"._ALL_STATUSSES."</option>";
				while($row = mysql_fetch_assoc($result)) {
					if($row['status_id'] == $this->order_status) {
						$selected = ' selected ';
					} else {
						$selected = '';
					}
					echo "<option {$selected} value='{$row['status_id']}'>{$row['status_name']}</option>";
				}
				echo "</select>";
			echo "</div>";
			
			echo "<script type='text/javascript'>";
				echo "$('#order_status').change(function() {
					$('#order_status_name').attr('value', $(this).find('option[value=\"' + $(this).val() + '\"]').html());
				});";
			echo "</script>";
			
			$sel1 = "";
			$sel2 = "";
			$sel3 = "";
			if ($this->period=='_DAYS') {
				$sel1="checked";
			} else if ($this->period=='_WEEKS') { 
				$sel2="checked";
			} else if ($this->period=='_MONTHS') { 
				$sel3="checked";
			}
			echo "<div class='form-group'><label>".strtoupper(substr(_REPORT,0,1)).substr(_REPORT,1).' '._PERIOD."</label>";
			
			echo "<div><input class='noTextInput report_option_field' style='width: 25px; margin: 0;' type=\"radio\" id='period' name=\"period\" value=\"_DAYS\" {$sel1}> "._DAYS."</div>";
			echo "<div><input class='noTextInput report_option_field' style='width: 25px; margin: 0;' type=\"radio\" id='period' name=\"period\" value=\"_WEEKS\" {$sel2}> "._WEEKS."</div>";
			echo "<div><input class='noTextInput report_option_field' style='width: 25px; margin: 0;' type=\"radio\" id='period' name=\"period\" value=\"_MONTHS\" {$sel3}> "._MONTHS."</div>";
			echo "</div><br/>";
		} else if($session->canEditProfiles()) {
			echo "<div class='form-group'><a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a></div>";
		}
	}
	function DefineQuery() {
		global $db;

		if ($this->order_status != '0') {
			$sql = " AND o.order_status_id = ". $db->Quote($this->order_status);
		} else {
			$sql = " AND o.order_status_id > '0'";
		}
		
		if (!empty($this->from)) {
			$sql .= " AND DATE(o.date_added) >= '" . date('Y-m-d', $this->from) . "'";
		}

		if (!empty($this->to)) {
			$sql .= " AND DATE(o.date_added) <= '" . date('Y-m-d', $this->to) . "'";
		}
		
		if ($this->period=='_DAYS') {
			$qd=",'%Y-%m-%d'"; 
		} else if ($this->period=='_WEEKS') { 
			$this->allowDateFormat = false;
			$qd=",'%Y-%u'";
		} else if ($this->period=='_MONTHS') { 
			$this->allowDateFormat = false;
			$qd=",'%Y-%M '"; 
		}
		
		$query = "SELECT DATE_FORMAT(o.date_added{$qd}) as datum,
				(SELECT `code` from {$this->tableprefix}currency WHERE `value` = 1) as currency,
				sum(o.total) as totRevenue,
				SUM((SELECT SUM(`value`) FROM {$this->tableprefix}order_total WHERE order_id = o.order_id AND code = 'tax')) as taxTotal,
				SUM((SELECT `value` FROM {$this->tableprefix}order_total WHERE order_id = o.order_id AND code = 'shipping')) as ship,
				sum(o.commission) as com,
				SUM((SELECT `value` FROM {$this->tableprefix}order_total WHERE order_id = o.order_id AND code = 'sub_total')) AS netRevenue,
				SUM((SELECT `value` FROM {$this->tableprefix}order_total WHERE order_id = o.order_id AND code = 'coupon')) AS TotCoupon,
				COUNT(o.order_id) as orders
			FROM `{$this->tableprefix}order` as o 
			WHERE o.store_id = ". $db->Quote($this->oc_store) ."
			{$sql}
			GROUP BY datum ASC;";
			
		return $query;
	}
	function GetReportData(){
		$data = [];
		$import = [];
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection == false){ echoNotice($this->SettingsButton()._CONNECTION_TO_DATABASE_FAILED); exit();}
		$query = $this->DefineQuery();
		
		$currency = "";
		
		$f = $this->from;
		$t = $this->to;
		if($this->period == '_DAYS'){		
			while($f < $t){
				$d = date('Y-m-d', $f);
				$import[$d]["totRevenue"] = 0.00;
				$import[$d]["TotCoupon"] = 0.00;
				$import[$d]["tax"] = 0.00;
				$import[$d]["ship"] = 0.00;
				$import[$d]["com"] = 0.00;
				$import[$d]["turnover"] = 0.00;
				$import[$d]["orders"] = 0;
				$f = $f + 86400;
			}		
		}			
		$result = mysql_query($query,$connection);
		while($row = mysql_fetch_array($result)) {
			if(!empty($row['currency'])) {
				$currency = $row["currency"];
			}
			$d = $row["datum"];
			$import[$d]["totRevenue"] = $row["totRevenue"];
			$import[$d]["tax"] = $row["taxTotal"];
			$import[$d]["ship"] = $row["ship"];
			$import[$d]["com"] = $row["com"];
			$import[$d]["turnover"] = $row["netRevenue"];
			$import[$d]["orders"] = $row["orders"];
			$import[$d]["TotCoupon"] = $row["TotCoupon"];
		}
		$i = 0;
		foreach($import as $k => $v){				
			if($this->period == '_WEEKS'){
				$dp = explode("-",$k);
				$data[$i][0] = "{$dp[0]} ". _WEEK." {$dp[1]}";
			}else if($this->period == '_MONTHS'){
				$dp = explode("-",$k);
				$data[$i][0] = "{$dp[1]} {$dp[0]}";
			}else{
				$data[$i][0] = $k;
			}
			$data[$i][1] = (empty($v["totRevenue"]) ? 0.00 : $v["totRevenue"]);
			$data[$i][2] = (empty($v["tax"]) ? 0.00 : $v["tax"]);
			$data[$i][3] = (empty($v["ship"]) ? 0.00 : $v["ship"]);
			$data[$i][4] = (empty($v["com"]) ? 0.00 : $v["com"]);
			$data[$i][5] = (empty($v["TotCoupon"]) ? 0.00 : $v["TotCoupon"]);
			$data[$i][6] = (empty($v["turnover"]) ? 0.00 : $v["turnover"]);
			$data[$i][7] = (empty($v["orders"]) ? 0 : $v["orders"]);
			$i ++;
		}
		
		mysql_close($connection);
		
		if(empty($this->order_status_name)) { $this->order_status_name = _ALL_STATUSSES; }
		
		$this->addlabel .= _ORDER_STATUS.": {$this->order_status_name}";
		$this->addlabel .= " | "._PERIOD.": ".constant($this->period);
		$this->addlabel .= " | ". _CURRENCY .": {$currency}";	
		
		return $data;
	}
	function DefineReport(){
		$this->externDbConnectForm("openCartConnect");	
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}
?>