<?php

/**
 * @desc This report displays a overview of your top keywords
 */
$reports["_LANDING_PAGE"] = array(
    "ClassName" => "LandingPage",
    "Category" => "_POPULAR_CONTENT",
    "icon" => "images/icons/32x32/topkeywords.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,human",
    "Filename" => "landing_page",
    "Distribution" => "Premium",
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "canAggregate" => false
);

class LandingPage extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->actionmenu_type = 'page';
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;

        $this->columnDefinitions[] = array("Label" => "_LANDING_PAGE", "actionmenu" => 'page');
        if (isset($this->sourcetype) && ($this->sourcetype == "keywords" || $this->sourcetype == "referrer")) {
            //ok
        } else {
            $this->sourcetype = "keywords";
        }

        if (empty($this->view)) {
            $this->view = "";
        }
        if ($this->view == "All") {
            $this->columnDefinitions[] = array(
                "Label" => "_PARAMETERS",
                "actionmenu" => 'params',
                "dataType" => "String"
            );
            $this->sort_key = 2;
            $this->fileNameExpension .= 'all';
        }
        if (!empty($this->source)) {
            $this->fileNameExpension .= md5($this->source);
        }

        $this->columnDefinitions[] = array("Label" => "_HITS");

        $this->columnDefinitions[] = array("Label" => "_VISITS");

        $this->addlabel = " {$this->sourcetype}: " . isset($this->source);
    }


    function DefineQuery()
    {
        global $db, $nc;

        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $refparams = "";

        if ($this->sourcetype == "keywords") {
            $table = $this->profile->tablename_keywords;
            $field = "keywords";
        } else {
            if ($this->sourcetype == 'referrer') {
                $table = $this->profile->tablename_referrers;
                $field = "referrer";

                if (strpos($this->source, '?') !== false) {
                    $this->source = explode("?", $this->source);
                    $refparams = "?" . $this->source[1];
                    $this->source = $this->source[0];
                    $table = "{$this->profile->tablename_refparams} as rp," . $this->profile->tablename_referrers;

                    $field = "refparams = rp.id  AND a.referrer";
                }
            }
        }

        if ($this->view == "All") {
            $select = "u.url,up.params";
            $from_table = ", {$this->profile->tablename_urlparams} as up";
            $join = "and a.params=up.id ";
        } else {
            $select = "u.url";
            $from_table = "";
            $join = "";
        }

        $query = "select {$nc} {$select}, count(*) as hits, count(DISTINCT visitorid) as visitors from {$tablename} as a, $table as k, {$this->profile->tablename_urls} as u $from_table where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote($this->to) . " and k.{$this->sourcetype}=" . $db->Quote(
                $this->source
            ) . " and a.$field=k.id and a.url=u.id {$join} group by {$select} ORDER BY hits DESC LIMIT {$this->limit}";

        return $query;
    }

    function DisplayCustomForm()
    {
        echo "<div class='form-group'>";
        echo "<label for='view'>" . _VIEW . "</label>";
        echo "<select class='report_option_field form-control' name='view'>
				<option value='page' ";
        if (isset($this->view) == "page") {
            echo "selected=\"selected\"";
        }
        echo ">" . _LANDING_PAGE . "</option>
				<option value='All' ";
        if (isset($this->view) == "All") {
            echo "selected=\"selected\"";
        }
        echo ">" . _LANDING_PAGE . " + " . _PARAMETERS . "</option>
			</select>";
        echo "</div>";

        echo "<div class='form-group'>";
        echo "<label for='sourcetype'>" . _SEARCH . "</label>";
        echo "<div class='input-group'>";
        echo '<div class="styled-select">';
        echo "<select class='report_option_field form-control' id='sourcetype'>";
        echo "<option value=\"keywords\" ";
        if (isset($this->sourcetype) == "keyword") {
            echo "selected=\"selected\"";
        }
        echo ">" . _KEYWORD . ": </option>";
        echo "<option value=\"referrer\" ";
        if (isset($this->sourcetype) == "referrer") {
            echo "selected=\"selected\"";
        }
        echo ">" . _REFERRER . ": </option>";
        echo "</select>";
        echo "</div>";
        echo "<input style='float:left;width:100%;max-width:170px;' placeholder='" . _SEARCH . "' class='report_option_field form-control' type=\"text\" name=\"source\" id=\"source\" value=\"" . urldecode(
                isset($this->source)
            ) . "\" onkeyup=\"popupActionMenu(event, this.value+'@'+this.id+'@'+$('#sourcetype').val(), 'forminput');\" onclick=\"popupMenu(event, this.value+'@'+this.id+'@'+$('#sourcetype').val(), 'forminput');\" autocomplete=\"off\">";
        echo '<span class="small"></span>';
        echo "</div>";
        echo "</div>";
    }

    function DisplayReport()
    {
        if (empty($this->source)) {
            $this->ReportHeader();
            echoNotice($this->SettingsButton() . _PLEASE_PROVIDE_KEYW_OR_REF, "margin-left:15px;");
            return;
        }
        parent::DisplayReport();
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

