<?php

/**
* @desc This report displays the error trends
*/
$reports["_ERROR_TRENDS"] = Array(
	"ClassName" => "ErrorTrends", 
	"Category" => "_PROBLEMS", 
	"icon" => "images/icons/32x32/errortrends.png",
	"Options" => "daterangeField,profileselector,trafficsource,period,displaymode,limit",
	"Filename" => "error_trends",
	"Distribution" => "Premium",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false,
	"canAggregate" => false
);

class ErrorTrends extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "areachart";
		$this->DisplayModes = "table,linechart,areachart";
		$this->displayReportButtons = false;		
		if(empty($this->period)){ $this->period = '_DAYS';  }
		$this->chartoptions = array("stacked_graph_style" => "stack", "stacked_showcontrols" => false, "showlegend" => true);
	}
	
	function GetReportData() {
		global $reports;
		$r = new $reports["_ERROR_REPORT"]["ClassName"]();
		$r->dataCollectType = "days";
		$r->createDataFiles($this->from,$this->to);	
		$d = $r->getTrendDataFromFiles($r->DataFiles($this->from,$this->to));
		
		$data = [];		
		foreach($d as $k => $v){
			$l = 0;
			if( !is_array($v)) { continue; }
			foreach($v as $val){		
				if ($this->limit < 50 && $l > ($this->limit * 5)){
					break;
				} else if ($this->limit >= 50 && $l > ($this->limit * 2)){
					break;
				}
				
				$timestamp = mktime(0, 0, 0, substr($k, 4, -2), substr($k, 6, 7), substr($k, 0, 4));
				
				# Define the chosen period / time unit
				if ($this->period == '_DAYS') { 
					$format = "D, m/d/Y";
					$date = date($format,$timestamp);
					
				} else if ($this->period == '_WEEKS') {
					$format = "Y-#W";
					$date = date($format,$timestamp);
					$date = str_replace("#","W",$date);
				} else if ($this->period == '_MONTHS') {
					$format = "M Y";
					$date = date($format,$timestamp);
				}	
				
				$error = $val[0];
				
				
				
				if(!isset($this->crawlerselect) || $this->crawlerselect == 0) {
					$viewed = $val[1];
				} else if(isset($this->crawlerselect) && $this->crawlerselect == 2) {
					$viewed = $val[1] + $val[2];
				} else {
					$viewed = $val[2];
				}
				
				if(isset($data[$error][$date])) {				
					$data[$error][$date] = $data[$error][$date] + $viewed;
				} else {	
					$data[$error][$date] = $viewed;
				}
				$l ++;
		
			}
		}
		ksort($data);
		$temp_d = [];		
		foreach($data as $error => $v){
			$temp_d[$error] = array_sum($v);
		}
		arsort($temp_d);
		
		$final = [];
		$i = 0;
		$l = 0;
		foreach($temp_d as $error => $v){
			if($l > $this->limit){
				break;
			}			
			foreach($data[$error] as $date => $viewed){
				$final[$i][0] = $date; 
				$final[$i][1] = $error; 
				$final[$i][2] = $viewed; 
				$i ++;
			}			
			$l ++;
		}
		
		$data = $this->ConvertData($final);
		return $data;
	}
	function ConvertData($data = "") {
		global $db;
		if(empty($data)) { $data = $this->GetReportData(); }
		# transform the data array to a column for each serie
		
		$data = $this->seriesToColumns($data);
		
		if(empty($data)){
			return $this->EmptyTrendData();
		}	
		
		foreach($data['fields'] as $key => $val) { // Add link to error report
			$data['fields'][$key] = "<td><a class=\"small open_in_new_dialog quickopen\" name=\"{$val} "._ERROR_REPORT."\" type=\"_ERROR_REPORT\" rel=\"ErrorReport\" href=\"reports.php?labels=_ERROR_REPORT&status=".urlencode($val)."&from={$this->from}&to={$this->to}&conf={$this->profile->profilename}&status={$val}\">{$val}</a></td>";
			$this->columnDefinitions[] = array("Label" => $val);
		}
		$this->setupColumnDefinitions();
		
		# create an empty seed array with the right dimensions
		$ncols = count($data['fields']);
		$nrows = $this->dateNumber($this->from, $this->to, $this->period);
		
		$seed_data = $this->newReportArray($nrows, $ncols);
		# add a date to he first value of each row.
		$seed_data = $this->AddDateToZeroArray($seed_data);
		
		# merge the actual results with the seed_data array
		foreach ($data['data'] as $key => $val) {
			if($this->period == '_WEEKS'){
				$dparts = explode("-",$key);
				$year = mktime(0,0,0,1,1,$dparts[0]);
				$week = str_replace("W","",$dparts[1]);
			
				$timestamp = (86400 * 7 * $week) + $year;		
			} else {
				$timestamp = strtotime($key);
			}
			
			$day_id = $this->dateNumber($this->from,$timestamp, $this->period);
			
			for ($i=0;$i<$ncols;$i++) {
				if (isset($val[$i])) {
					$seed_data[$day_id][$i] = $val[$i];
				}
			}		
		}	
		ksort($seed_data);
		
		# now make sure the date column is properly filled
		foreach($seed_data as $key => $value) {
			$value[0] = $this->getFormatDate($this->period,($this->from+(($key)*$this->getSeconds($this->period))));
			$seed_data[$key] = $value;
		}
		
		return $seed_data;
	}

	function DisplayCustomForm() {
		echo "<div class='form-group'>";
		echo "<label for=\"crawlerselect\">"._TRAFFIC.": </label>";
		echo "<select class='report_option_field form-control' id=\"crawlerselect\" name=\"crawlerselect\">";
			echo "<option ";
			if(isset($this->crawlerselect) && $this->crawlerselect == 2) {
				echo"selected='selected'";
			}
			echo " value='2'>"._ALL_HUMANS_AND_BOTS."</option>";
			echo "<option ";
			if(!isset($this->crawlerselect) || $this->crawlerselect == 0) {
				echo"selected='selected'";
			}
			echo " value='0'>"._HUMANS_ONLY."</option>";
			echo "<option "; if(isset($this->crawlerselect) && $this->crawlerselect == 1) {
				echo"selected='selected'";
			}
			echo " value=\"1\">"._BOTS_ONLY."</option>";
		echo "</select>";
		echo "</div>";
	}
	
	function DisplayReport() {
		global $db, $qd;
		
		# get the data from the database
		$data = $this->GetReportData();
		//dump($data);
		if(empty($data)) {
			$this->ReportHeader();			
			echoNotice($this->SettingsButton()._NO_DATA_TO_DISPLAY, "margin-left:15px;");
			return;
		}
				
		$this->addlabel .= _GROUPED_BY . " ".constant($this->period);

		if(isset($this->crawlerselect) && $this->crawlerselect == 2) {
			$this->addlabel .= " | "._ALL_HUMANS_AND_BOTS."";
		}	
		if(!isset($this->crawlerselect) || $this->crawlerselect == 0) {
			$this->addlabel .= " | "._HUMANS_ONLY."";
		}
		if(isset($this->crawlerselect) && $this->crawlerselect == 1) {
			$this->addlabel .= " | "._BOTS_ONLY."";
		}


		$this->ReportHeader();

		if($this->displaymode == 'table') {
			$this->Table($data);
		} elseif($this->displaymode == 'areachart') {
			
			$this->StackedAreaChart2($data);

		} elseif($this->displaymode == 'linechart') {
			
			$this->LineChart($data);
		}
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# not using datafiles yet
		return false;		
	}
}
?>