<?php

/**
* @desc This report displays a overview of referrrer conversion.
*/

$reports["_COUNTRY_CONVERSION"] = Array(
	"ClassName" => "CountryConversion", 
	"Category" => "_PERFORMANCE",
	"canAggregate" => false,  
	"icon" => "images/icons/32x32/country_conversion.png",
	"Options" => "daterangeField,profileselector,trafficsource,roadto,limit,displaymode,columnSelector",
	"Filename" => "country_conversion",
	"Distribution" => "Premium",
	"Order" => 7,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class CountryConversion extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "pie,table";
		$this->columnDefinitions[] = array("Label" => "_COUNTRY");
		$this->columnDefinitions[] = array("Label" => "_CONVERTED_VISITORS","bchart" => true);
		$this->columnDefinitions[] = array("Label" => "_CONVERSION_RATE");
		$this->datafiles = false;
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;		
		
		if(empty($this->displaymode)) { $this->displaymode = $this->DefaultDisplay; }
	}
	
	function DefineQuery() {
		global $db, $nc;
		
		# Select all countries and visitors per each country
		# We can't rely on a limit here
		$query = "SELECT country, COUNT(DISTINCT visitorid) AS ips FROM {$this->profile->tablename} WHERE timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND country != '' GROUP BY country ORDER BY ips DESC";
		
		return $query;
	}

	function GetReportData() {
		$data = parent::GetReportData();
		$data = $this->ConvertData($data);
		return $data;
	}


	
	function ConvertData($data) {
		global $db, $cnames;
		
		$cdata = [];
		foreach($data as $entry) {
			if($this->displaymode == 'pie') {
				$cdata[$entry[0]][0] = $cnames[$entry[0]];
			} else {
				$cdata[$entry[0]][0] = $entry[0];
			}
				$cdata[$entry[0]][1] = $entry[1];
		}

		# Select top [limit] converted countries
		$query = "SELECT
			country,
			COUNT(DISTINCT visitorid) AS visitors
		FROM
			{$this->profile->tablename} AS a,
			{$this->profile->tablename_urls} AS u
		WHERE
			timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ."
			AND (status = 200 or status = 302)
			AND a.url = u.id
			AND u.url = ". $db->quote($this->roadto) ."
			AND country != ''
		GROUP BY country
		ORDER BY visitors DESC
		LIMIT ". $this->limit;
		
		$q = $db->Execute($query);		
		# Prepare a data array, with country as key and insert countries and visitors
		while($row = $q->FetchRow()) {			
			$total = $cdata[$row[0]][1];			
			$cdata[$row[0]][1] = $row[1];
			$cdata[$row[0]][2] = number_format((($row[1] / $total) * 100), 2)."%";
		}
		

		# Merge prepared data array with converted data array
		# Use an integer as key; $this->Table function expects it to be
		# We also skip countries that didn't convert
		$c = 0;
		$seed_data = [];
		foreach($cdata as $key => $entry) {
			if(!empty($entry[2])) {
				$seed_data[$c] = $cdata[$key];
				$c++;
			}
		}
		
		# Sort the data by conversion rate
		if(!empty($seed_data)) {
			$seed_data = DataSort($seed_data, 1);
		}
		return $seed_data;
	}
	
	function DisplayReport() {	
		if (empty($this->profile->targetfiles)) {
			$this->ReportHeader();
			echoNotice(_REPORT_NEEDS_KPI. "<br/><br/><a href='profile.php?conf={$this->profile->profilename}#_KPI' class='btn btn-default'>". _EDIT_PROFILE .": ". _KPI ."</a>", "margin:10px;");
			return;
		}

		parent::DisplayReport();
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>