<?php

/**
* @desc This report lets you make split test of your pages and gives you an overview of wich one works the best.
*/
$reports["_BANDWIDTH"] = Array(
	"ClassName" => "Bandwidth", 
	"Category" => "_TRAFFIC",
	"icon" => "images/icons/32x32/bandwidth.png",
	"Options" => "daterangeField,profileselector,displaymode",
	"Filename" => "bandwidth",
	"Distribution" => "Premium",
	"Order" => 7,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"DeleteOutdatedFiles" => false,
	"Update" => false
);

class Bandwidth extends Report {
	function Settings() {
		$this->DefaultDisplay = "barchart";
		$this->DisplayModes = "table,linechart,barchart";
		$this->allowDateFormat = false;
		$this->dataCollectType = "months";		
		$this->key_col = 0;
		
		# Set some default values
		if(empty($this->byte_value)) { $this->byte_value = _MEGABYTES; }
		if(empty($this->period)) { $this->period = '_DAYS'; }		
		
		# Set the bytes column to the right name for the display. We are transforming the bytes to kb or mb by users choice
		if($this->byte_value == _MEGABYTES) {
			$colname = _MEGABYTES;		
		} elseif($this->byte_value == _KILOBYTES) {
			$colname = _KILOBYTES;
		} else {
			$colname = _BYTES;
		}
		
		$this->columnDefinitions[] = array("Label" => "_PERIOD");
		$this->columnDefinitions[] = array("Label" => $colname);
		
		if (!empty($this->displaymode) && $this->displaymode=="table" && $this->period != '_DAYS') {
			$this->columnDefinitions[] = array("Label" => _AVERAGE);
		}
		
		
	}
	
	function GetReportData(){
		$d = $this->getTrendDataFromFiles($this->dataFiles($this->from,$this->to));			
		$data = [];
		
		foreach($d as $k => $m){
			# Foreach entry in this month
			if(!is_array($m)){ continue; }
			
			foreach($m as $day){
				$val = 0;
				if($this->byte_value == _KILOBYTES) {
					$val = round($day[1] / 1024);
				} elseif($this->byte_value == _MEGABYTES) {
					$val = round(($day[1] / 1024) / 1024);
				} else {
					$val = $day[1];
				}
				
				$dateparts = explode("-", $day[0]);
				$timestamp = mktime(0,0,0,$dateparts[1],$dateparts[2],$dateparts[0]);

				if($timestamp < $this->from || $timestamp > $this->to){
					continue;
				}
				
				if($this->period == '_MONTHS') {
					$date = date("M Y", $timestamp);
					$key = date("Ym", $timestamp);
				} elseif($this->period == '_WEEKS') {
					$date = str_replace("%", " ". _WEEK ." ", date("Y %W", $timestamp));
					$key = date("YW", $timestamp);
				} else {
					$date = LogaDate($this->profile->dateFormat, $timestamp);
					$key = date("Ymd", $timestamp);
				}
				
				$data[$key][0] = $date;
				$data[$key][1][] = $val;	
			}
		}
		ksort($data);
		
		$i = 0;
		$newdata = [];
		foreach($data as $k => $v) {
			$newdata[$i][0] = $v[0];
			$newdata[$i][1] = array_sum($v[1]);
			if ($this->displaymode=="table") {
				$newdata[$i][2] = array_sum($v[1]) / count($v[1]);
			}			
			$i++;
		}		
		
		return $newdata;
	}
	
	function DisplayCustomForm() {
		echo "<div class='form-group'>";
			echo "<label for='period'>Sum results per:</label>";
			echo "<select id='period' name='period' class='form-control'>";
				echo "<option value='_DAYS'";
					if($this->period == '_DAYS') { echo " selected "; }
				echo ">"._DAYS."</option>";
				echo "<option value='_WEEKS'";
					if($this->period == '_WEEKS') { echo " selected "; }
				echo ">"._WEEKS."</option>";
				echo "<option value='_MONTHS'";
					if($this->period == '_MONTHS') { echo " selected "; }
				echo ">"._MONTHS."</option>";
			echo "</select>";		
		echo "</div>";
		echo "<div class='form-group'>";
			echo "<label for='byte_value'>Byte Metric:</label>";
			echo "<select id='byte_value' name='byte_value' class='form-control'>";
				echo "<option value='"._MEGABYTES."'";
					if($this->byte_value == _MEGABYTES) { echo " selected "; }
				echo ">"._MEGABYTES."</option>";
				echo "<option value='"._KILOBYTES."'";
					if($this->byte_value == _KILOBYTES) { echo " selected "; }
				echo ">"._KILOBYTES."</option>";
				echo "<option value='"._BYTES."'";
					if($this->byte_value == _BYTES) { echo " selected "; }
				echo ">"._BYTES."</option>";
			echo "</select>";		
		echo "</div>";
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){
		# This report creates datafiles during update.
		return false;
	}
}