<?php

include_once "common.inc.php";
AccessCheck();

if (!isset($_REQUEST["conf"])) { die('missing required parameter'); }
?>
<link href="components/jquery/css/lightness/jquery-ui-1.8.custom.css" rel="stylesheet" type="text/css">

<script src="components/jquery/js/jquery-1.11.3.min.js" type="text/javascript"></script>
<script src="components/jquery/js/jquery-ui.min.js" type="text/javascript"></script>
<script src="components/jquery/js/jquery.sparkline.min.js" type="text/javascript"></script>
<style type='text/css'>
body{
	margin:0;
}

.inpage_container {	
	background:#e0e0e0;
	border: 1px solid black;
	height:100%;
	width:190px;
	margin:0;
	padding:0;
	font-family: Tahoma, sans-serif;
	font-size:12px;	color:#333333;
	text-shadow: 0 1px 0 #ffffff;
} 
.spark_container {	
	float:left;	
	padding:5px 9px;
	margin:4px;	border:1px solid #EEEFEF;
	border-radius:3px;
	width: 160px;
} 
.uptrend{ color: green; } 
.downtrend{ color: red; } 
.heatMapDotContent a{ color:#fff; text-decoration:underline; }	
#from,#to{  margin: 5px; font-size: 10px; width: 100px; background: none repeat scroll 0 0 rgb(224, 224, 224); color: rgb(0, 0, 0); border: 1px solid rgb(238, 239, 239); }

#inpage_date_picker{ float: left; font-size: 10px; text-align:right; width: 160px;}
.report_target { cursor:pointer; }

#from_helper,#to_helper{ background: #FFFFCC;
    border: 1px solid gold;
    margin-left: 55px;
    margin-top: 4px;
    padding: 1px;
    position: absolute;
	text-align: left;
	display:none;
    width: 96px; }
#from_helper{ margin-top: 21px; }
#to_helper{ margin-top: 48px; }
</style>
<?php
$from_date = (isset($_GET["inpage_from"])) ? date("m/d/Y",$_GET["inpage_from"]) : date("m/01/Y",time());
$to_date = (isset($_GET["inpage_to"])) ? date("m/d/Y",$_GET["inpage_to"]) : date("m/d/Y",time());

$date_help = 'The format is: Month/Day/Year
Quick switch days: UP and DOWN arrow keys.
Quick switch month: Page Up and Page Down keys.';
?>
<div class="inpage_container">
	<span style='float: left; font-size: 10px; text-align:center; width:100%;' >Logaholic Inpage Analytics</span>
	<div id="inpage_date_picker">
		<div id="from_helper"></div>
		<label>From</label><input type=text id="from" title="<?php echo $date_help; ?>" value="<?php echo $from_date; ?>" onkeyup="datepicker(this.value,'from');">
		<br/>
		<div id="to_helper"></div>
		<label>To</label><input type=text id="to" title="<?php echo $date_help; ?>" value="<?php echo $to_date; ?>" onkeyup="datepicker(this.value,'to');">	
	</div>
	
	<div id="report_container">
		<div class="report_target" id="_TREND_ANALYSIS"></div>
		<div class="report_target" id="_PAGE_TRENDS"></div>
		<div class="report_target" id="_PAGETIME"></div>
		<div class="report_target" id="_BOUNCE_RATE"></div>
		<div class="report_target" id="_PAGE_ANALYSIS"></div>
	</div>
</div>
<script type="text/javascript">
var lg_url = "";
var curpage = "<?php echo $_GET["page"]; ?>";
var lg_profile = "<?php echo $_GET["conf"]; ?>";
var reload_timer;

var months = [ "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec" ];
var active = "from";

$(document).ready( function(){
	create_sparkline_graphs(lg_profile);
	
	$(".report_target").on("click",function(){
		window.top.location = "<?php echo $_GET["lg_url"]; ?>?conf="+lg_profile;
	});
});

$(document).keydown(function(e){
	if (e.keyCode == 38) { 
		//up, we move a day back
		shiftDay("back");
		return;		   
	}
	if (e.keyCode == 40) { 
		//down, we move a day forward
		shiftDay("forward");
		return;		   
	}
	if (e.keyCode == 33) { 
		//page up, we move a month back
		shiftMonth("back");
		return;		   
	}
	if (e.keyCode == 34) { 
		//page down, we move a month forward
		shiftMonth("forward");

	}
});

$('#from,#to').live('DOMMouseScroll mousewheel', function (e) {
  if(e.originalEvent.detail > 0 || e.originalEvent.wheelDelta < 0) { //alternative options for wheelData: wheelDeltaX & wheelDeltaY
	//scroll down
	shiftDay("forward");
  } else {
	//scroll up
	shiftDay("back");
  }
  //prevent page fom scrolling
  return false;
});

$("#from_helper").live("click", function() { usethis('from'); });
$("#to_helper").live("click", function() { usethis('to'); });
$("#from").live("focus", function() { active="from" });
$("#to").live("focus", function() { active="to" });

function ResetGraphs(){
	reload_timer;
	
	clearTimeout(reload_timer);
	
	reload_timer = setTimeout(function() {
		var lgfrom = getTimestamp($("#from").attr("value"));
		if(lgfrom == false){
			return false;
		}
		
		var lgto = getTimestamp($("#to").attr("value"));
		if(lgto == false){
			return false;
		}
		var url = "//<?php echo $profile->confdomain; ?>"+curpage+"?conf="+lg_profile+"&inpage_from="+lgfrom+"&inpage_to="+lgto;
		console.log(url);
		window.top.location = url;
		
	}, 2000);
}


function create_sparkline_graphs(){
	var lgfrom = getTimestamp($("#from").attr("value"));
	if(lgfrom == false){
		return false;
	}
	
	var lgto = getTimestamp($("#to").attr("value"));
	if(lgto == false){
		return false;
	}
	sourceurl = lg_url + "reports.php?conf="+lg_profile+"&from="+lgfrom+"&to="+lgto;
	
	$("#_PAGE_ANALYSIS").html("");
	url = sourceurl + '&labels=_PAGE_ANALYSIS&outputmode=sparkline&page=' + curpage;
	url = encodeURI(url);
	$.ajax({
	  url: url,
	  dataType: 'jsonp'
	});

	$("#_PAGE_TRENDS").html("");
	url = sourceurl + '&labels=_PAGE_TRENDS&outputmode=sparkline&viewData=pv&searchmode=equals&search=' + curpage;
	url = encodeURI(url);
	$.ajax({
	  url: url,
	  dataType: 'jsonp'
	});
	
	$("#_PAGETIME").html("");
	url = sourceurl + '&labels=_PAGETIME&outputmode=sparkline&page=' + curpage;
	url = encodeURI(url);
	$.ajax({
	  url: url,
	  dataType: 'jsonp'
	});
	
	$("#_TREND_ANALYSIS").html("");
	url = sourceurl + '&labels=_TREND_ANALYSIS&sourcetype=page&outputmode=sparkline&source=' + curpage;
	$.ajax({
	url: url,
	  dataType: 'jsonp'
	});		
	
	$("#_BOUNCE_RATE").html("");
	url = sourceurl + '&labels=_BOUNCE_RATE&outputmode=sparkline&page=' + curpage;
	$.ajax({
	  url: url,
	  dataType: 'jsonp'
	});	
	
	$("#from").change( function(){
		ResetGraphs();
	});
	$("#to").change( function(){
		ResetGraphs();
	});
}

function getTimestamp(cDate){
	cDate = cDate.split("/");
	
	now = new Date();
	now.setMonth((cDate[0]-1));
	now.setDate(cDate[1]);
	now.setFullYear(cDate[2]);
	var lgdate = now.getTime();
	
	lgdate = Math.round(lgdate / 1000);
	
	if(lgdate < 0 || isNaN(lgdate) ){	
		alert("Invalid Daterange");
		return false;
	}
	
	return lgdate;
}

function shiftDay(mode) {
	now = getDateStr();	
	if (mode=="forward") {
		now.setDate((now.getDate()+1));
	} else {
		now.setDate((now.getDate()-1));
	}
	
	var day = now.getDate();
	if(day < 10){
		day = "0"+day;
	}
	var month = parseInt(now.getMonth()+1);
	if(month < 10){
		month = "0"+month;
	}
	
	now = month + "/" + day + "/" + now.getFullYear();
	document.getElementById(active).value = now;
	ResetGraphs();
}

function shiftMonth(mode) {
	now = getDateStr();
	if (mode=="forward") {
		now.setMonth((now.getMonth()+1));
	} else {
		now.setMonth((now.getMonth()-1));
	}
	
	var day = now.getDate();
	if(day < 10){
		day = "0"+day;
	}
	var month = parseInt(now.getMonth()+1);
	if(month < 10){
		month = "0"+month;
	}
	
	now = month + "/" + day + "/" + now.getFullYear();
	document.getElementById(active).value = now;
	ResetGraphs();
}

function getDateStr() {
	var str = document.getElementById(active).value;
	cDate = str.split("/");
	
	now = new Date();
	now.setMonth((cDate[0]-1));
	now.setDate(cDate[1]);
	now.setFullYear(cDate[2]);
	return now;		
}

function hidehelper(id) {
	$('#'+id+'_helper').hide();
	return true;
}

function usethis(id) {
	document.getElementById(id).value = $("#"+id+"_helper").html();
	hidehelper(id);
}

function datepicker(str,id) {
	
	if (str.length==0) {
		
		var now = new Date();
		now.setDate(1);                   // setting date to 1 is first day of current month
		now = (now.getMonth()+1) + "/" + now.getDate() + "/" + now.getFullYear()
		$("#"+id+"_helper").html(now);
		$("#"+id+"_helper").show();
		return;
	}
	
	if (str.length < 3) {
		if (isNaN(str)==false) {
			var now = new Date();
			
			now.setDate(str);
			now = (now.getMonth()+1) + "/" + now.getDate() + "/" + now.getFullYear()
			
			
			$("#"+id+"_helper").html(now);
			$("#"+id+"_helper").show();
			return;
		}
	}
	
	if (str.length >= 3) {
		if (isNaN(str)==true) {
			m = months.indexOf(str.toLowerCase());
			if (m > -1) { 
				var now = new Date();				
				now = (m+1) + "/01/" + now.getFullYear()
				
				
				$("#"+id+"_helper").html(now);
				$("#"+id+"_helper").show();

				
			}
		
		} else {
			if (str > 1980 && str < 2050) {
				var now = new Date();				
				now = "1/1/" + str;

				$("#"+id+"_helper").html(now);
				$("#"+id+"_helper").show();

			}
		}
	}
	
}
</script>