<?php

if(!defined('APP_INCLUDE')){ die('invalid inclusion'); }
 
require_once 'upload_dir.php';
class Upgrade_logaholic extends UploadDir {
	//runs on local server.
	var $Main_directory, $Backup_directory, $ZIP_array;
	
	function Upgrade_logaholic(){
		$this->Main_dir();
		$this->Backup_directory = $this->getUploadDir();
	}

	function RemoveBackups(){
		$files = glob(logaholic_dir() . "files/backup/{,.}*",GLOB_BRACE);
		if(empty($files)){
			return;
		}

		foreach($files as $backup){
			@unlink($backup);
		}
		@rmdir(logaholic_dir() . "files/backup");
	}
	
	function Backup(){
		global $hash;
		$hash = md5(time());
		$backupDir = logaholic_dir() . "files/backup/";

		$exists_files = glob($backupDir.LOGAHOLIC_VERSION_NUMBER."*");
		if(empty($exists_files)) {

			if(!is_dir($backupDir . LOGAHOLIC_VERSION_NUMBER.".$hash")) {
				$this->Recursive_walk('', '', LOGAHOLIC_VERSION_NUMBER.".$hash");
			}

			if(strpos(strtolower($_SERVER['SERVER_SOFTWARE']), 'win32') !== false || strpos(strtolower($_SERVER['SERVER_SOFTWARE']), 'win64') !== false) {
				$this->zipBackup($backupDir,LOGAHOLIC_VERSION_NUMBER.".$hash");
			} else {
				exec("cd $backupDir; tar -czf ". LOGAHOLIC_VERSION_NUMBER .".$hash.tar.gz ".LOGAHOLIC_VERSION_NUMBER.".$hash"); 
				exec("rm -rf $backupDir". LOGAHOLIC_VERSION_NUMBER.".$hash"); 
			}
		}	
	}
	
	function Directory_scan($path){
		return scandir($path);
	}
	
	//Gets the current active directory.
	function Main_dir(){
		$this->Main_directory = logaholic_dir();
	}
	
	function Make_directory($Directory){
		return @mkdir($Directory, 0777);
	}
	
	function File_isDirectory($path){
		return is_dir($path);
	}
	
	function Copy_file($Source, $Destination){
		return @copy($Source, $Destination);
	}
	
	function CreateHtaccessFile(){
		if(file_exists("$this->Backup_directory/.htaccess")){
			return;
		}

		$fp = fopen("$this->Backup_directory/.htaccess",'w+');
		fwrite($fp,"deny from all");
		fclose($fp);
	}

	function Recursive_walk($Directory = '', $Copy_directory = '', $Create_directory = ''){
		if($Directory == "" && $Copy_directory == ""){
			if($Create_directory != ''){
				$this->Backup_directory .= 'backup';
				$this->Make_directory($this->Backup_directory);
				$this->CreateHtaccessFile($this->Backup_directory);

				$this->Backup_directory .= '/'.$Create_directory;
				$this->Make_directory($this->Backup_directory);
			}
			$Directory = $this->Main_directory;
			$Copy_directory = $this->Backup_directory;
		}
		
		$File_array = preg_grep('#(.svn|data|files)#', $this->Directory_scan($Directory), PREG_GREP_INVERT);
		foreach($File_array as $Key => $Value){
			if($Value != '.' && $Value != '..'){
				$File_path = $Directory.'/'.$Value;
				$Copy_file_path = $Copy_directory.'/'.$Value;
				if($this->File_isDirectory($File_path) && $Value != $Create_directory){
					$this->Make_directory($Copy_file_path);
					$this->Recursive_walk($File_path, $Copy_file_path, $Create_directory);
				}else{
					$this->Copy_file($File_path, $Copy_file_path);
				}
			}
		}
	}//end of function
	function zipaddGlob($zip, $dir){
		global $hash;
		$bckpDir = logaholic_dir() . "files/backup/". LOGAHOLIC_VERSION_NUMBER . ".$hash/";
		$ignoreFolders = array("files","data");
		foreach(glob($dir . '/*') as $file) {
			$newname = str_replace($bckpDir,"",$file);
			if(is_dir($file)) {
				$zip->addEmptyDir($newname);
				if(!in_array($newname,$ignoreFolders)) {
					$this->zipaddGlob($zip,$file);
				}
			} else {
				$zip->addFile($file, $newname);
			}
		}
	}
	
	# recursively remove a directory
	function rrmdir($dir) {
		$files = @glob($dir . '/{,.}*', GLOB_BRACE);
		if(empty($files)){
			return;
		}

		foreach($files as $file) {
			if(is_dir($file))
				$this->rrmdir($file);
			else
				@unlink($file);
		}
		@rmdir($dir);
	}
	
	function zipBackup($backupDir, $version){
		set_time_limit(86400);
		$zip = new ZipArchive();
		$zipfile = $backupDir . $version . ".zip";
		
		if ($zip->open($zipfile, ZIPARCHIVE::CREATE)===TRUE) {
			$this->zipaddGlob($zip,$backupDir . $version);
			if($zip->close()){
				$this->rrmdir($backupDir . $version);
			}
		} else {
			//
		}
	}
}
?>