<?php

require_once '../../AccessControl.php';

function ProfileListMenu()
{
    global $db, $session, $validUserRequired;

    $where = "";
    if ($validUserRequired && !$session->isAdmin() && !$session->allProfiles) {
        $validprofiles = array();
        for ($i = count($session->user_profiles) - 1; $i >= 0; $i--) {
            $validprofiles[] = $db->Quote($session->user_profiles[$i]);
        }
        if (empty($validprofiles)) {
            return array();
        }
        $where = " where profilename in (" . implode(",", $validprofiles) . ")";
    }
    $limitsql = "";
    if (defined("_LIMIT_PROFILES") != 0 && _LIMIT_PROFILES < 5) {
        $limitsql = "LIMIT " . _LIMIT_PROFILES;
    } else {
        $userprofiles = array();
        $q = $db->Execute("SELECT username, profiles FROM " . TBL_USERS . "");
        while ($data = $q->fetchRow()) {
            $p = explode(",", $data['profiles']);
            foreach ($p as $profs) {
                $userprofiles[$profs] = $data['username'];
            }
        }
    }

    $db->SetFetchMode(ADODB_FETCH_NUM);
    $q = $db->Execute(
        "SELECT profilename, activated, '', lastused, sessioncounter, stats FROM " . TBL_PROFILES . " $where ORDER BY lastused DESC $limitsql"
    );
    //$q = $db->Execute("SELECT profilename, activated, lastused, sessioncounter FROM ". TBL_PROFILES . " $where ORDER BY lastused DESC $limitsql");
    $p = array();


    while ($data = $q->fetchRow()) {
        try {
            $data[3] = "<span style='display:none;' class='sorter'>{$data[3]}</span>" . date("Y/m/d H:i", $data[3]);

            //$data[4]= number_format($data[4]);

            if (isset($userprofiles[$data[0]])) {
                $data[6] = $userprofiles[$data[0]];
            } else {
                $data[6] = 0;
            }

            $stats = json_decode($data[5], true);
            if (isset($stats["thirtyday_pageviews"])) {
                $data[4] = "<span style='display:none;' class='sorter'>{" . (int)$stats["thirtyday_pageviews"] . "}</span><span title=\"Shows pageviews over the most recent 30 days\n\nAll time visits: " . number_format(
                        (int)$data[4]
                    ) . " from " . date("Y/m/d", (int)$stats["firstRequestTimeEver"]) . " to " . date(
                        "Y/m/d",
                        (int)$stats["max_db_timestamp"]
                    ) . "\nDatabase data starts at " . date(
                        "Y/m/d",
                        (int)$stats["min_db_timestamp"]
                    ) . "\">" . number_format(
                        $stats["thirtyday_pageviews"]
                    ) . "</span><span style='display:none;'>{$data[6]}</span>";
            } else {
                $data[4] = "-";
            }

            $data[5] = "<span style='display:none;' class='sorter'>{" . (int)$stats["max_db_timestamp"] . "}</span>" . date(
                    "Y/m/d",
                    (int)$stats["max_db_timestamp"]
                );


            $p[] = $data;
        } catch (Exception $e) {
            die($e);
        }
    }

    $db->SetFetchMode(ADODB_FETCH_BOTH);
    return $p;
}

$plist = ProfileListMenu();

$result = array();
$result["data"] = $plist;
echo json_encode($result);
?>