
var authMethod = {};
$(document).ready(function(){	
	$.ajax({
		url: "app/model/AuthenticationMethod.php",
		success: function(result) {
			var data = ui.ParseJSON(result);
			if(data.Status == undefined || data.Status != "Success"){
				ui.Callout({ Status : "Error", Message : ui.data.languages["_SOMETHING_WRONG_W_COLLECTING"] });
				return;
			}
			authMethod.Load(data);
		}
	});
});

authMethod.Load = function(data){
	if(Object.keys(data.Admins).length > 0){
		$("#ChangeMethod").show();
	} else {
		$("#AddAdmin").show();
	}

	$("#ChangeMethod .radio input[value='"+ data.Authtype +"']").attr("checked", "checked");

	if(data.Authtype == ui.data.languages['USER_AUTHENTICATION_OTHER']){
		$("#serval").show();
	}

	$("#ChangeMethod input[name='authtypevar']").attr("value", data.UserAuthVar);

	$("#ChangeMethod .radio:not(.showserval)").on("click", function(){ $("#serval").hide(); });
	$("#ChangeMethod .showserval").on("click", function(){ $("#serval").show(); });

	$("#ChangeMethod .btn").on("click", function(e){
		e.preventDefault();

		var btn = $(this);
		btn.button('loading');

		var fd = FormObjectToArray( $("#autheditor") );

		authMethod.GetModal(fd , function(result){
  			btn.button('reset');  

			var data = ui.ParseJSON(result);
			if(data.Status == undefined || data.Status != "Success"){
				ui.Callout({ Status : "Error", Message : ui.data.languages["_SOMETHING_WRONG_W_COLLECTING"] });
				return;
			}

			ui.Callout(data);
		});
	});
}

authMethod.GetModal = function(post_data , callback){
	$.ajax({
		url: "app/model/AuthenticationMethod.php",
		data : post_data,
		type : "POST",
		success: function(result) {
			var data = ui.ParseJSON(result);
			if(data.Status == "Success"){
				callback(result);
			}			
		}
	});
}