'use strict';
const webpack = require('webpack');
const path = require('path');

module.exports = {

    mode: 'development',
    entry: [
        './assets/js/main.js',
    ],
    devtool: 'source-map',
    module: {
        rules: [
            {
                test: /\.js$/,
                loader: 'babel-loader'
            },
            {
                test: /\.css$/,
                use: [
                    'css-loader',
                    'postcss-loader',
                ]
            },
            {
                test: /\.scss$/,
                use: [
                    'css-loader',
                    'postcss-loader',
                    'sass-loader',
                ]
            },
            {
                test: require.resolve('jquery'),
                loader: 'expose-loader',
                options: {
                    exposes: ['$', 'jQuery']
                }
            },
            {
                test: require.resolve('jqplot-exported'),
                loader: 'expose-loader',
                options: {
                    exposes: ['jqPlot']
                }
            },
        ]
    },
    resolve: {
        extensions: ['.vue', '.js']
    },
    plugins: [
        new webpack.ProvidePlugin({
            $: 'jQuery',
            jquery: 'jQuery',
            jqPlot: 'jqPlot',
        }),
    ],
    output: {
        filename: '[name].bundle.js',
        path: path.resolve(__dirname, 'public/js'),
        clean: true,

    },
}