<?php

/**
 * @desc This report shows how many users follow you.
 */
$reports["_TWITTER_FIND_PEOPLE"] = [
    "ClassName" => "TwitterFindPeople",
    "Category" => "_TWITTER",
    "icon" => "images/icons/32x32/twitter_followers.png",
    "Options" => "limit",
    "Filename" => "twitter_find_people",
    "Distribution" => "Premium",
    "Order" => 4,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "DeleteOutdatedFiles" => false,
    "Update" => false
];

class TwitterFindPeople extends TwitterCore
{
    function Settings()
    {
        parent::Settings();
        $this->DisplayModes = "table";
        $this->DefaultDisplay = "table";
        $this->columnDefinitions[] = ["Label" => ""]; # No need to tell this is the icon column in the UI
        $this->columnDefinitions[] = ["Label" => "_NAME"];
        $this->columnDefinitions[] = ["Label" => "_FOLLOWERS", "bchart" => true];
        $this->columnDefinitions[] = ["Label" => "Tweets"];
        $this->columnDefinitions[] = ["Label" => "_FAVOURITES"];
        $this->columnDefinitions[] = ["Label" => "_FOLLOW"];
    }

    function DisplayCustomForm()
    {
        if (!empty($this->keyword)) {
            $keyword = $this->keyword;
        } else {
            $keyword = '';
        }
        return "<div class='form-group'><label for='keyword'>" . _INSERT_KEYWORD . "</label><input type='text' id='keyword' class='report_option_field form-control' name='keyword' value='{$keyword}' /></div>";
    }

    function DisplayReport()
    {
        $data = $this->GetReportData();
        $this->ReportHeader();
        if (empty($this->keyword)) {
            echoNotice($this->SettingsButton() . _INSERT_KEYWORD);
            return false;
        }

        $data = $this->GetReportData();

        echo "<div class='twitter-profiles'>";
        $this->Table($data);
        echo "<script>			
			window.twttr.widgets.load();
		</script>
		</div>";
    }

    function GetReportData()
    {
        $this->addlabel = "Search: ";
        $this->displayReportButtons = false;
        if (empty($this->keyword)) {
            return [];
        }
        $this->addlabel .= $this->keyword;

        $users = $this->TwitterCall("users", urlencode($this->keyword));

        if (empty($users)) {
            return [];
        }
        $data = [];
        $i = 0;
        foreach ($users as $key => $value) {
            $data[$key][0] = "<a href='https://twitter.com/{$value['screen_name']}' target='_blank'><img alt='' src='{$value['profile_image_url']}' width='32' /></a>";
            $data[$key][1] = "<a href='https://twitter.com/{$value['screen_name']}' target='_blank'>{$value['screen_name']}</a>";
            $data[$key][2] = $value['followers_count'];
            $data[$key][3] = $value['statuses_count'];
            $data[$key][4] = $value['favourites_count'];
            $data[$key][5] = "<a class='twitter-follow-button' data-show-screen-name='false' data-show-count='false' href='https://twitter.com/{$value['screen_name']}'>Follow</a>";
        }
        $data = DataSort($data, 2);
        return $data;
    }
}

