<?php

/**
 * @desc This report shows how many users follow you.
 */

$reports["_TWITTER_COMPARE"] = [
    "ClassName" => "TwitterCompare",
    "Category" => "_TWITTER",
    "icon" => "images/icons/32x32/twitter_followers.png",
    "Options" => "limit,displaymode",
    "Filename" => "twitter_compare",
    "Distribution" => "Premium",
    "Order" => 4,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "DeleteOutdatedFiles" => false,
    "Update" => false
];

class TwitterCompare extends TwitterCore
{
    function Settings()
    {
        $this->DisplayModes = "table,barchart";
        $this->DefaultDisplay = "table";
        if (empty($this->displaymode) || $this->displaymode == "table") {
            $this->columnDefinitions[] = ["Label" => ""]; # No need to tell this is the icon column in the UI
        }
        $this->columnDefinitions[] = ["Label" => "TwitterName"];
        $this->columnDefinitions[] = ["Label" => "Followers"];
        $this->columnDefinitions[] = ["Label" => "Following"];
        $this->columnDefinitions[] = ["Label" => "Tweets"];
        $this->columnDefinitions[] = ["Label" => "Favourites"];
        // $this->columnDefinitions[] = array("Label" => "Followed?");

        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul>
		<li>TwitterName: That accounts user name.</li>
		<li>Followers: The amount of followers that account has.</li>
		<li>Following: The amount of twitter accounts that account is following.</li>
		<li>Tweets: The amount of tweets that account has.</li>
		<li>Favourites: The amount of favourites that account has.</li></ul>';
    }

    function DisplayCustomForm()
    {
        $form = "<div class='form-group'>" .
            "<label for='author'>Twitter Account 1:</label>
                <input type='text' name='User1'
                value='" . @$this->User1 . "' class='report_option_field form-control' /> " .
            "</div>" .
            "<div class='form-group'>" .
            "<label for='author'>Twitter Account 2:</label>
                <input type='text' name='User2'
                value='" . @$this->User2 . "' class='report_option_field form-control' />" .
            "</div>";
        return $form;
    }

    function SearchFollowing($userid, $username, $cursor)
    {
        $following = $this->TwitterCall("followers", $username, $cursor);

        if (empty($following["ids"])) {
            return false;
        }

        if (in_array($userid, $following["ids"])) {
            return true;
        }

        # empty also checks int 0
        if (!empty($following['next_cursor'])) {
            return $this->SearchFollowing($userid, $username, $following['next_cursor']);
        }

        return false;
    }

    function DisplayReport()
    {
        $this->ReportHeader();

        if (empty($this->User1) || empty($this->User2)) {
            echoNotice($this->SettingsButton() . "Please insert 2 twitter user names");
            return false;
        }

        $data = $this->GetReportData();
        if ($this->displaymode == "barchart") {
            $this->BarChart($data);
        } else {
            $this->Table($data);
        }
    }

    function GetReportData()
    {
        $users1 = $this->TwitterCall("user", urlencode($this->User1));
        $users2 = $this->TwitterCall("user", urlencode($this->User2));

        // # Check if user 2 is following user 1
        // $follower1 = $this->SearchFollowing($users2["id"], $this->User1, "-1");
        // if($follower1){
        // 	$users2['following_user'] = "Not Followed";
        // } else {
        // 	$users2['following_user'] = "Followed";
        // }


        // # Check if user 1 is following user 2
        // $follower2 = $this->SearchFollowing($users1["id"], $this->User2, "-1");
        // if($follower2){
        // 	$users1['following_user'] = "Not Followed";
        // } else {
        // 	$users1['following_user'] = "Followed";
        // }


        $users = [$users1, $users2];
        //dump($users);
        $data = [];
        foreach ($users as $key => $value) {
            if ($this->displaymode == "table") {
                $data[$key][0] = "<a href='https://twitter.com/{$value['screen_name']}' target='_blank'><img alt='' src='{$value['profile_image_url']}' width='32' /></a>";
                $data[$key][1] = $value['screen_name'];
                $data[$key][2] = $value['followers_count'];
                $data[$key][3] = $value['friends_count'];
                $data[$key][4] = $value['statuses_count'];
                $data[$key][5] = $value['favourites_count'];
                // $data[$key][6] = $value['following_user'];
            } else {
                $data[$key][0] = $value['screen_name'];
                $data[$key][1] = $value['followers_count'];
                $data[$key][2] = $value['friends_count'];
                $data[$key][3] = $value['statuses_count'];
                $data[$key][4] = $value['favourites_count'];
            }
        }
        return $data;
    }
}

