<?php

$reports["_TRANSALARM_LOG_DETAIL"] = [
    "ClassName" => "TransalarmLogDetail",
    "Category" => "_TRANSALARM",
    "icon" => "images/icons/32x32/goals.png",
    "Options" => "",
    "Filename" => "trans_alarm_log_detail",
    "Distribution" => "Unlisted",
    "hidden" => true,
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 4.0,
    "EmailAlerts" => true,
    "Update" => false
];

class TransalarmLogDetail extends Report
{
    function Settings()
    {
        global $logaTA;
        $this->columnDefinitions[] = ["Label" => "_TIMESTAMP"];
        $this->columnDefinitions[] = ["Label" => '_EVENT'];
        $this->columnDefinitions[] = ["Label" => '_PROFILE'];
        $this->columnDefinitions[] = ["Label" => '_METRIC'];
        $this->columnDefinitions[] = ["Label" => '_TEST_START'];
        $this->columnDefinitions[] = ["Label" => '_TEST_END'];
        $this->columnDefinitions[] = ["Label" => '_BASELINE'];
        $this->columnDefinitions[] = ["Label" => '_DENOMINATOR'];
        $this->columnDefinitions[] = ["Label" => '_OBSERVED'];

        if (!empty($this->sandbox)) {
            $logaTA->LogTable = TBL_TRANSALARM_LOG . "_sandbox";
        }
    }

    function DisplayCustomForm()
    {
        echo "<label>" . _SEARCH_FOR_METRIC . "</label>";
        echo "<input class='report_option_field' type='text' placeholder='Metric' value='" . @$this->metric . "' name='metric' id='metric' /><br/>";

        echo "<label style='line-height: 38px;'>";
        if (!empty($this->sandbox)) {
            echo "<input class='report_option_field' type='checkbox' style='float: left;  margin: 13px 0 0; width: 20px;' name='sandbox' id='sandbox' checked='checked' />";
        } else {
            echo "<input class='report_option_field' type='checkbox' style='float: left;  margin: 13px 0 0; width: 20px;' name='sandbox' id='sandbox' />";
        }
        echo "Sandbox";
        echo "</label>";
    }

    function GetReportData()
    {
        global $db;
        $data = [];

        $r = $db->Execute($this->DefineQuery());

        while ($row = $r->fetchRow()) {
            $c = $this->EventColor($row[1]);

            $sandbox = "";
            if (!empty($this->sandbox)) {
                $sandbox = "&sandbox=1";
            }

            $data[] = [
                0 => date(implode($this->profile->dateFormat) . " H:i:s", $row[0]),
                1 => "<span style='color:{$c}'>{$row[1]}</span>",
                2 => $row[2],
                3 => "<a class='open_in_this_dialog quickopen' type='_TRANSALARM_LOG_DETAIL' name='" . _TRANSALARM_LOG_DETAIL . "' href='reports.php?conf={$this->profile->profilename}&labels=_TRANSALARM_LOG_DETAIL&metric={$row[3]}{$sandbox}'>{$row[3]}</a>",
                4 => ($row[4] == '') ? '-' : date(implode($this->profile->dateFormat) . " H:i:s", $row[4]),
                5 => ($row[5] == '') ? '-' : date(implode($this->profile->dateFormat) . " H:i:s", $row[5]),
                6 => ($row[6] == '') ? '-' : $row[6],
                7 => ($row[8] == '') ? '-' : $row[8],
                8 => ($row[10] == '') ? '-' : $row[10]
            ];
        }
        return $data;
    }

    function DefineQuery()
    {
        global $db, $logaTA;
        $search = "";

        if (!empty($this->metric)) {
            $search = "AND metric = " . $db->Quote($this->metric);
        }

        $query = "SELECT * FROM " . $logaTA->LogTable . " WHERE profile = '{$this->profile->profilename}' $search ORDER BY timestamp ASC";
        return $query;
    }

    function EventColor($e)
    {
        if (substr($e, 0, 1) == 6) {
            return 'purple';
        } else {
            if (substr($e, 0, 1) == 4) {
                return 'green';
            } else {
                if (substr($e, 0, 1) == 3) {
                    return 'red';
                } else {
                    if (substr($e, 0, 1) == 2) {
                        return 'orange';
                    } else {
                        if (substr($e, 0, 1) == 1) {
                            return 'red';
                        } else {
                            return 'black';
                        }
                    }
                }
            }
        }
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}