<?php

$reports["_TRAFFIC_FLOW"] = [
    "ClassName" => "TrafficFlow",
    "Category" => "_NAVIGATION",
    "icon" => "images/icons/32x32/traffic_flow.png",
    "Options" => "daterangeField,profileselector,limit",
    "Filename" => "traffic_flow",
    "Distribution" => "Premium",
    "Order" => 7,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false,
    "hidden" => true,
    "canAggregate" => false
];

class TrafficFlow extends Report
{

    function Settings()
    {
        $this->displayReportButtons = false;
        if (!isset($this->source) || empty($this->source)) {
            $this->source = "/";
        }
        if (!isset($_REQUEST['limit'])) {
            $_REQUEST['limit'] = 20;
        }
        if ($this->limit > 25) {
            $this->limit = 25;
        }
        $this->help = "<span>" . _TRAFFIC_FLOW_HOW_TO_READ . ":</span>
			<ul>" . _TRAFFIC_FLOW_HOW_TO_READ_LIST . "</ul>
			<span>" . _TIPS . ":</span>
			<ul>" . _TRAFFIC_FLOW_TIPS_LIST . "</ul>
			<span>" . _OPTIONS . ":</span>
			<ul>" . _TRAFFIC_FLOW_OPTIONS_LIST . "</ul>";

        $this->actionmenu_type = 'page';
    }

    function DisplayCustomForm()
    {
        echo "<div class='form-group'>";
        echo "<label for=\"source\">" . _PAGE . "</label>";
        echo "<input type=\"hidden\" id=\"sourcetype\" value=\"page\">";
        echo "<input id=\"source\" class=\"report_option_field form-control\" type=\"text\" autocomplete=\"off\" onclick=\"popupMenu(event, this.value+'@'+this.id+'@'+$('#sourcetype').val(), 'forminput');\" onkeyup=\"popupActionMenu(event, this.value+'@'+this.id+'@'+$('#sourcetype').val(), 'forminput');\" value=\"{$this->source}\" name=\"source\">";
        echo "</div>";
    }

    function urlid_to_refid($urlid)
    {
        global $db;

        $url = getVAL($urlid, "urls");

        $ref = "https://" . $this->profile->confdomain . $url;

        $refid = getID($ref, "referrers");

        return $refid;
    }

    function DisplayReport()
    {
        $this->ReportHeader();
        $this->chordGraphCreate();
        echo "<div style='clear:both;'>&nbsp;</div>";
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

