<?php


$reports["_TOP_PAGES_DETAILS"] = [
    "ClassName" => "TopPagesDetails",
    "Category" => "_POPULAR_CONTENT",
    "icon" => "images/icons/32x32/toppagesdetails.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector,human",
    "Filename" => "top_pages_details",
    "Distribution" => "Premium",
    "Order" => 2,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "canAggregate" => false
];

class TopPagesDetails extends Report
{
    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_PAGE", "actionmenu" => 'page'];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        $this->actionmenu_type = 'page';
        $this->sort_key = 1;
        $this->sort_order = SORT_DESC;
        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul>' . '<li>' . _PAGE_DETAILS_DEFINITION . '<li>' . _VISITS_DEFINITION . '<li>' . _PAGEVIEWS_DEFINITION . '</ul>';
    }

    function GetReportData()
    {
        global $db, $get_constant;
        $this->createDataFiles($this->from, $this->to);
        $d = $this->getDataFromFiles($this->dataFiles($this->from, $this->to));
        $data = [];
        $i = 0;
        foreach ($d as $val) {
            $data[$i][0] = $val[0];
            $data[$i][1] = $val[1];
            $data[$i][2] = $val[2];
            $i++;
        }
        return $data;
    }

    function DefineQuery()
    {
        global $nc, $db;
        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $subquery = subsetDataToSourceID(
            "select concat(url,'.',params) as numfurl,url,params,count(distinct sessionid) as visits,count(*) as hits,count(distinct visitorid) as visitors from {$tablename} where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote($this->to) . " group by numfurl, url, params order by visits desc",
            $this->trafficsource
        );
        $query = "select IF(r.title = '',concat(r.url,rp.params),concat(r.url,rp.params,'##',r.title)) as furl, sq.visits,sq.hits, sq.visitors  FROM ({$subquery}) as sq, {$this->profile->tablename_urls} as r, {$this->profile->tablename_urlparams} as rp WHERE sq.url=r.id and sq.params=rp.id";
        $this->applytrafficsource = false;

        return $query;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        false;
    }
}


