<?php

/**
 * @desc This report displays a overview of your top exit pages
 */
$reports["_TOP_EXIT_PAGES"] = [
    "ClassName" => "TopExitPages",
    "Category" => "_NAVIGATION",
    "icon" => "images/icons/32x32/topexitpages.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
    "Filename" => "top_exit_pages",
    "Distribution" => "Premium",
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "canAggregate" => false
];

class TopExitPages extends Report
{
    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_PAGE", "actionmenu" => 'page'];
        $this->columnDefinitions[] = ["Label" => "_EXITS"];
        $this->actionmenu_type = 'page';
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
    }

    function DefineQuery()
    {
        global $databasedriver, $db;

        if (empty($this->limit)) {
            $this->limit = 100;
        }

        if ($databasedriver == "sqlite") {
            $db->Execute("BEGIN TRANSACTION");
        }

        $pg = "DROP TABLE IF EXISTS {$this->profile->tablename}_temptable_maxdates";
        $db->Execute($pg);
        $pg = "create temporary table {$this->profile->tablename}_temptable_maxdates (max_visitorid char(32), max_timestamp int(11))";
        $db->Execute($pg);
        $pg = "insert into {$this->profile->tablename}_temptable_maxdates select yt1.visitorid max_visitorid, max(yt1.timestamp) max_timestamp from {$this->profile->tablename} as yt1 where (yt1.timestamp >=" . $db->quote(
                $this->from
            ) . " and yt1.timestamp <=" . $db->quote($this->to) . ") group by yt1.visitorid";
        $db->Execute($pg);
        $query = "select IF(u.title = '',u.url,CONCAT(u.url,'##',u.title)) as urlinfo, count(visitorid) as hits from {$this->profile->tablename}_temptable_maxdates, {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u where (visitorid = max_visitorid) and (timestamp = max_timestamp) and (a.url=u.id) group by a.url, u.title, u.url order by hits desc";

        return $query;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }
}


