<?php

/**
 * @desc This report displays a overview of the screen resolutions
 */
$reports["_SCREEN_RESOLUTION"] = [
    "ClassName" => "ScreenResolution",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/screenresolution.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
    "Filename" => "screen_resolution",
    "Distribution" => "Standard",
    "Order" => 12,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false
];

class ScreenResolution extends Report
{

    function Settings()
    {
        //$this->datafiles=false;
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_SCREEN_RESOLUTION"];
        $this->columnDefinitions[] = ["Label" => "_AVG_VIEWPORT"];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        //$this->columnDefinitions[] = array("Label" => "vph");
        $this->sort_key = 2;
        $this->sort_order = SORT_DESC;
        // get logaholic.gif id
        $this->gifid = getID("/logaholic.gif", "urls");
        if ($this->gifid == false) {
            $this->gifid = 'false';
            return false;
        }

        global $profile;
        include "includes/codespace.php";
        $this->help = _SCREEN_RESOLUTION_DESC . '<br><br>' . _GIFDATA_REPORT_DESC . "<br><br>" . _REPORT_NEEDS_GIFDATA . " " . _TAG_LOGFILES . "<br><br>" . $codespace2;
    }

    function DefineQuery()
    {
        global $db;
        if ($this->gifid == 'false') {
            return false;
        }

        $q = subsetDataToSourceID(
            "select CONCAT(CONVERT(lg_getparam('sw',u.params), SIGNED INTEGER),' x ',CONVERT(lg_getparam('sh',u.params), SIGNED INTEGER)) as res, CONVERT(lg_getparam('vpw',u.params), SIGNED INTEGER) as vpw, CONVERT(lg_getparam('vph',u.params), SIGNED INTEGER) as vph from {$this->profile->tablename_gifdata} as a, {$this->profile->tablename_urlparams} as u where a.params=u.id and a.url={$this->gifid} and a.timestamp >= " . $db->quote(
                $this->from
            ) . " AND a.timestamp <= " . $db->quote($this->to) . " and u.params like '%&sw=%'",
            $this->trafficsource
        );

        $q = "select res, count(*) hits, sum(vpw), sum(vph) from ($q) as a where vph > 0 and vpw > 0 group by res order by hits desc";

        $this->applytrafficsource = false;
        return $q;
    }

    function GetReportData()
    {
        $data = parent::GetReportData();
        foreach ($data as $k => $v) {
            $data[$k][2] = ($v[2] / $v[1]);
            $data[$k][3] = ($v[3] / $v[1]);
            $data[$k][1] = intval($data[$k][2]) . " x " . intval($data[$k][3]);
            $data[$k][2] = $v[1];
        }
        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}


